/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.runner;

import com.github.searls.jasmine.io.scripts.ScriptResolver;
import com.github.searls.jasmine.io.scripts.ScriptResolverException;
import com.github.searls.jasmine.runner.AbstractSpecRunnerHtmlGenerator;
import com.github.searls.jasmine.runner.HtmlGeneratorConfiguration;
import com.github.searls.jasmine.runner.SpecRunnerHtmlGenerator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.stringtemplate.v4.ST;

public class DefaultSpecRunnerHtmlGenerator
extends AbstractSpecRunnerHtmlGenerator
implements SpecRunnerHtmlGenerator {
    protected DefaultSpecRunnerHtmlGenerator(HtmlGeneratorConfiguration configuration) {
        super(configuration);
    }

    @Override
    public String generate() {
        try {
            ScriptResolver resolver = this.getConfiguration().getScriptResolver();
            return this.generateHtml(resolver.getAllScripts(), resolver.getPreloads(), resolver.getSources(), resolver.getSpecs(), resolver.getSourceDirectory(), resolver.getSpecDirectory());
        }
        catch (ScriptResolverException e) {
            throw new RuntimeException("Failed to load files for dependencies, sources, or a custom runner", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load files for dependencies, sources, or a custom runner", e);
        }
    }

    private String generateHtml(Set<String> allScripts, Set<String> preloads, Set<String> sources, Set<String> specs, String sourceDirectory, String specDirectory) throws IOException {
        ST template = this.resolveHtmlTemplate();
        this.applyScriptTagsToTemplate("javascriptDependencies", Arrays.asList("/webjars/jasmine/jasmine.js", "/webjars/jasmine/jasmine-html.js", "/classpath/lib/htmlSpecFilterPatch.js", "/webjars/jasmine/boot.js"), template);
        this.applyCssToTemplate(Arrays.asList("/webjars/jasmine/jasmine.css"), template);
        this.applyScriptTagsToTemplate("allScriptTags", allScripts, template);
        this.applyScriptTagsToTemplate("preloadScriptTags", preloads, template);
        this.applyScriptTagsToTemplate("sourceScriptTags", sources, template);
        this.applyScriptTagsToTemplate("specScriptTags", specs, template);
        template.add("allScriptsList", (Object)this.createJsonArray(allScripts));
        template.add("preloadsList", (Object)this.createJsonArray(preloads));
        template.add("sourcesList", (Object)this.createJsonArray(sources));
        template.add("specsList", (Object)this.createJsonArray(specs));
        template.add("sourceDir", (Object)sourceDirectory);
        template.add("specDir", (Object)specDirectory);
        template.add("autoRefresh", (Object)this.getConfiguration().getAutoRefresh());
        template.add("autoRefreshInterval", (Object)this.getConfiguration().getAutoRefreshInterval());
        this.setCustomRunnerConfig(template);
        template.add("reporter", (Object)this.getConfiguration().getReporterType().name());
        this.setEncoding(this.getConfiguration(), template);
        this.applyScriptTagsToTemplate("sources", allScripts, template);
        template.add("specs", (Object)this.createJsonArray(specs));
        template.add("priority", (Object)this.createJsonArray(preloads));
        return template.render();
    }

    private String createJsonArray(Set<String> scripts) {
        if (null == scripts || scripts.isEmpty()) {
            return "[]";
        }
        StringBuilder builder = new StringBuilder("['");
        builder.append(StringUtils.join(scripts, (String)"', '"));
        builder.append("']");
        return builder.toString();
    }

    private void setCustomRunnerConfig(ST template) throws IOException {
        String customRunnerConfiguration = this.getConfiguration().getCustomRunnerConfiguration();
        template.add("customRunnerConfiguration", (Object)customRunnerConfiguration);
    }
}

