/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.support;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weixin.popular.api.TicketAPI;
import weixin.popular.bean.ticket.Ticket;
import weixin.popular.support.TokenManager;

public class TicketManager {
    private static final Logger logger = LoggerFactory.getLogger(TicketManager.class);
    private static ScheduledExecutorService scheduledExecutorService;
    private static Map<String, String> ticketMap;
    private static Map<String, ScheduledFuture<?>> futureMap;
    private static int poolSize;
    private static boolean daemon;

    static {
        ticketMap = new LinkedHashMap<String, String>();
        futureMap = new HashMap();
        poolSize = 2;
        daemon = Boolean.TRUE;
    }

    private static void initScheduledExecutorService() {
        logger.info("daemon:{},poolSize:{}", (Object)daemon, (Object)poolSize);
        scheduledExecutorService = Executors.newScheduledThreadPool(poolSize, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable arg0) {
                Thread thread = Executors.defaultThreadFactory().newThread(arg0);
                thread.setDaemon(daemon);
                return thread;
            }
        });
    }

    public static void setPoolSize(int poolSize) {
        TicketManager.poolSize = poolSize;
    }

    public static void setDaemon(boolean daemon) {
        TicketManager.daemon = daemon;
    }

    public static void init(String appid) {
        TicketManager.init(appid, 0, 7140);
    }

    public static void init(final String appid, int initialDelay, int delay) {
        if (scheduledExecutorService == null) {
            TicketManager.initScheduledExecutorService();
        }
        if (futureMap.containsKey(appid)) {
            return;
        }
        ScheduledFuture<?> scheduledFuture = scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                String access_token = TokenManager.getToken(appid);
                Ticket ticket = TicketAPI.ticketGetticket(access_token);
                ticketMap.put(appid, ticket.getTicket());
                logger.info("TICKET refurbish with appid:{}", (Object)appid);
            }
        }, initialDelay, delay, TimeUnit.SECONDS);
        futureMap.put(appid, scheduledFuture);
    }

    public static void destroyed() {
        scheduledExecutorService.shutdownNow();
        logger.info("destroyed");
    }

    public static String getTicket(String appid) {
        return ticketMap.get(appid);
    }

    public static String getDefaultTicket() {
        Object[] objs = ticketMap.values().toArray();
        return objs.length > 0 ? objs[0].toString() : null;
    }
}

