/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.bean.xmlmessage;

import com.qq.weixin.mp.aes.AesException;
import com.qq.weixin.mp.aes.WXBizMsgCrypt;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.UUID;

public abstract class XMLMessage {
    private String toUserName;
    private String fromUserName;
    private String msgType;

    protected XMLMessage(String toUserName, String fromUserName, String msgType) {
        this.toUserName = toUserName;
        this.fromUserName = fromUserName;
        this.msgType = msgType;
    }

    public abstract String subXML();

    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<xml>");
        sb.append("<ToUserName><![CDATA[" + this.toUserName + "]]></ToUserName>");
        sb.append("<FromUserName><![CDATA[" + this.fromUserName + "]]></FromUserName>");
        sb.append("<CreateTime>" + System.currentTimeMillis() / 1000L + "</CreateTime>");
        sb.append("<MsgType><![CDATA[" + this.msgType + "]]></MsgType>");
        sb.append(this.subXML());
        sb.append("</xml>");
        return sb.toString();
    }

    public boolean outputStreamWrite(OutputStream outputStream) {
        try {
            outputStream.write(this.toXML().getBytes("utf-8"));
            outputStream.flush();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean outputStreamWrite(OutputStream outputStream, WXBizMsgCrypt bizMsgCrypt) {
        if (bizMsgCrypt != null) {
            try {
                String outputStr = bizMsgCrypt.encryptMsg(this.toXML(), String.valueOf(System.currentTimeMillis()), UUID.randomUUID().toString());
                outputStream.write(outputStr.getBytes("utf-8"));
                outputStream.flush();
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            catch (AesException e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }
        return this.outputStreamWrite(outputStream);
    }
}

