/*
 * Decompiled with CFR 0.152.
 */
package indi.mybatis.flying.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class ReflectHelper {
    private static final Log logger = LogFactory.getLog(ReflectHelper.class);

    public static Field getFieldByFieldName(Object obj, String fieldName) {
        for (Class<?> superClass = obj.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            try {
                return superClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                logger.trace(new StringBuffer().append(e).toString());
                continue;
            }
        }
        return null;
    }

    public static Object getValueByFieldName(Object obj, String fieldName) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = ReflectHelper.getFieldByFieldName(obj, fieldName);
        Object value = null;
        if (field != null) {
            if (field.isAccessible()) {
                value = field.get(obj);
            } else {
                field.setAccessible(true);
                value = field.get(obj);
                field.setAccessible(false);
            }
        }
        return value;
    }

    public static void setValueByFieldName(Object obj, String fieldName, Object value) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field field = obj.getClass().getDeclaredField(fieldName);
        if (field.isAccessible()) {
            field.set(obj, value);
        } else {
            field.setAccessible(true);
            field.set(obj, value);
            field.setAccessible(false);
        }
    }

    public static Set<Class<?>> getClasses(String packageName) {
        LinkedHashSet classes = new LinkedHashSet();
        boolean recursive = true;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            block14: while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                switch (url.getProtocol()) {
                    case "file": {
                        String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                        ReflectHelper.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classes);
                        break;
                    }
                    case "jar": {
                        try {
                            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                            Enumeration<JarEntry> entries = jar.entries();
                            while (entries.hasMoreElements()) {
                                JarEntry entry = entries.nextElement();
                                String name = entry.getName();
                                if (name.charAt(0) == '/') {
                                    name = name.substring(1);
                                }
                                if (!name.startsWith(packageDirName)) continue;
                                int idx = name.lastIndexOf(47);
                                if (idx != -1) {
                                    packageName = name.substring(0, idx).replace('/', '.');
                                }
                                if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                                String className = name.substring(packageName.length() + 1, name.length() - 6);
                                try {
                                    classes.add(Class.forName(packageName + '.' + className));
                                }
                                catch (ClassNotFoundException e) {
                                    logger.error(new StringBuffer("Add user mapper class error, find no such.class file: ").append(e).toString());
                                }
                            }
                            continue block14;
                        }
                        catch (IOException e) {
                            logger.error(new StringBuffer("Error accessing file from jar package when scanning user mapper class: ").append(e).toString());
                            break;
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            logger.error(new StringBuffer().append(e).toString());
        }
        return classes;
    }

    private static void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, Set<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                ReflectHelper.findAndAddClassesInPackageByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + '.' + className));
            }
            catch (ClassNotFoundException e) {
                logger.error(new StringBuffer("Add user mapper class error to find no such. Class file: ").append(e).toString());
            }
        }
    }
}

