/*
 * Decompiled with CFR 0.152.
 */
package indi.mybatis.flying.models;

import indi.mybatis.flying.annotations.FieldMapperAnnotation;
import indi.mybatis.flying.annotations.ForeignAssociation;
import indi.mybatis.flying.exception.BuildSqlException;
import indi.mybatis.flying.exception.BuildSqlExceptionEnum;
import indi.mybatis.flying.models.ForeignAssociationMapper;
import indi.mybatis.flying.models.Mapperable;
import indi.mybatis.flying.models.TypeJdbcTypeConverter;
import indi.mybatis.flying.statics.AssociationType;
import indi.mybatis.flying.statics.OpLockType;
import indi.mybatis.flying.utils.JdbcTypeEnum;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashSet;
import javax.persistence.Column;
import javax.persistence.Id;
import org.apache.ibatis.type.JdbcType;

public class FieldMapper
implements Mapperable {
    private Field field;
    private String fieldName;
    private String dbFieldName;
    private JdbcType jdbcType;
    private String dbAssociationUniqueKey = "";
    private ForeignAssociationMapper[] foreignAssociationMappers;
    private String dbCrossedAssociationUniqueKey = "";
    private boolean isUniqueKey;
    private boolean isForeignKey;
    private boolean isCrossDbForeignKey;
    private String foreignFieldName;
    private boolean isOpVersionLock;
    private HashSet<String> ignoreTagSet;
    private String typeHandlerPath;
    private String fmaDbFieldName;
    private String columnFieldName;
    private OpLockType opLockType = OpLockType.Null;
    private String[] ignoreTag = new String[0];
    private FieldMapperAnnotation fieldMapperAnnotation;
    private Column column;
    private Id id;
    private boolean insertAble = true;
    private boolean updateAble = true;
    private Class<?> fieldType;
    private Class<?> subTarget;
    private AssociationType associationType;

    public void buildMapper() {
        if (this.fieldMapperAnnotation == null && this.column == null) {
            throw new BuildSqlException(BuildSqlExceptionEnum.noFieldMapperAnnotationOrColumnAnnotation.toString());
        }
        this.setFieldName(this.field.getName());
        this.setFieldType(this.field.getType());
        if (this.column != null) {
            this.setDbFieldName(FieldMapper.getColumnName(this.column, this.field));
            this.setJdbcType(FieldMapper.getColumnType(this.column, this.field));
            this.setInsertAble(this.column.insertable());
            this.setUpdateAble(this.column.updatable());
        }
        if (this.fieldMapperAnnotation != null) {
            this.setDbFieldName(this.fieldMapperAnnotation.dbFieldName());
            this.setJdbcType(this.fieldMapperAnnotation.jdbcType());
            this.setTypeHandlerPath(this.fieldMapperAnnotation.customTypeHandler());
            this.setOpLockType(this.fieldMapperAnnotation.opLockType());
            this.setUniqueKey(this.fieldMapperAnnotation.isUniqueKey());
            this.setIgnoreTag(this.fieldMapperAnnotation.ignoreTag());
            this.setDbAssociationUniqueKey(this.fieldMapperAnnotation.dbAssociationUniqueKey());
            this.setAssociationType(this.fieldMapperAnnotation.associationType());
            this.setDbCrossedAssociationUniqueKey(this.fieldMapperAnnotation.dbCrossedAssociationUniqueKey());
            if (this.fieldMapperAnnotation.associationExtra().length > 0) {
                ForeignAssociation[] fas = this.fieldMapperAnnotation.associationExtra();
                ForeignAssociationMapper[] fams = new ForeignAssociationMapper[this.fieldMapperAnnotation.associationExtra().length];
                int i = 0;
                for (ForeignAssociation fa : fas) {
                    fams[i] = new ForeignAssociationMapper(fa.dbFieldName(), fa.dbAssociationFieldName(), fa.condition());
                    ++i;
                }
                this.setForeignAssociationMappers(fams);
            }
        }
        if (this.id != null) {
            this.setUniqueKey(true);
        }
    }

    public boolean buildMapper(Field field) {
        Annotation[] fieldAnnotations = field.getDeclaredAnnotations();
        if (fieldAnnotations.length == 0) {
            return false;
        }
        for (Annotation an1 : fieldAnnotations) {
            if (an1 instanceof Id) {
                this.setId((Id)an1);
            }
            if (!(an1 instanceof FieldMapperAnnotation) && !(an1 instanceof Column)) continue;
            this.setField(field);
            if (an1 instanceof FieldMapperAnnotation) {
                this.setFieldMapperAnnotation((FieldMapperAnnotation)an1);
                continue;
            }
            if (!(an1 instanceof Column)) continue;
            this.setColumn((Column)an1);
        }
        this.buildMapper();
        return true;
    }

    public static String getColumnName(Column column, Field field) {
        if (!"".equals(column.name())) {
            return column.name();
        }
        return field.getName();
    }

    public static JdbcType getColumnType(Column column, Field field) {
        String columnDefinition_;
        JdbcType jdbcType;
        if (!"".equals(column.columnDefinition().trim()) && (jdbcType = JdbcTypeEnum.forName(columnDefinition_ = column.columnDefinition().indexOf(" ") > -1 ? column.columnDefinition().substring(0, column.columnDefinition().indexOf(" ")) : column.columnDefinition())) != null) {
            return jdbcType;
        }
        if (TypeJdbcTypeConverter.map.get(field.getType()) != null) {
            return TypeJdbcTypeConverter.map.get(field.getType());
        }
        return JdbcType.OTHER;
    }

    @Override
    public String getDbFieldName() {
        return this.dbFieldName;
    }

    public void setDbFieldName(String dbFieldName) {
        this.dbFieldName = dbFieldName;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public JdbcType getJdbcType() {
        return this.jdbcType;
    }

    public void setJdbcType(JdbcType jdbcType) {
        this.jdbcType = jdbcType;
    }

    @Override
    public String getDbAssociationUniqueKey() {
        return this.dbAssociationUniqueKey;
    }

    public void setDbAssociationUniqueKey(String dbAssociationUniqueKey) {
        this.dbAssociationUniqueKey = dbAssociationUniqueKey;
    }

    @Override
    public ForeignAssociationMapper[] getForeignAssociationMappers() {
        return this.foreignAssociationMappers;
    }

    public void setForeignAssociationMappers(ForeignAssociationMapper[] foreignAssociationMappers) {
        this.foreignAssociationMappers = foreignAssociationMappers;
    }

    public boolean isUniqueKey() {
        return this.isUniqueKey;
    }

    public void setUniqueKey(boolean isUniqueKey) {
        this.isUniqueKey = isUniqueKey;
    }

    @Override
    public boolean isForeignKey() {
        return this.isForeignKey;
    }

    public void setForeignKey(boolean isForeignKey) {
        this.isForeignKey = isForeignKey;
    }

    @Override
    public String getForeignFieldName() {
        return this.foreignFieldName;
    }

    public void setForeignFieldName(String foreignFieldName) {
        this.foreignFieldName = foreignFieldName;
    }

    public boolean isOpVersionLock() {
        return this.isOpVersionLock;
    }

    public void setOpVersionLock(boolean isOpVersionLock) {
        this.isOpVersionLock = isOpVersionLock;
    }

    public HashSet<String> getIgnoreTagSet() {
        if (this.ignoreTagSet == null) {
            this.ignoreTagSet = new HashSet();
        }
        return this.ignoreTagSet;
    }

    public void setIgnoreTagSet(HashSet<String> ignoreTagSet) {
        this.ignoreTagSet = ignoreTagSet;
    }

    @Override
    public String getTypeHandlerPath() {
        return this.typeHandlerPath;
    }

    public void setTypeHandlerPath(Class<?> typeHandler) {
        if (!Void.class.equals(typeHandler)) {
            this.typeHandlerPath = typeHandler.getName();
        }
    }

    public String getFmaDbFieldName() {
        return this.fmaDbFieldName;
    }

    public void setFmaDbFieldName(String fmaDbFieldName) {
        this.fmaDbFieldName = fmaDbFieldName;
    }

    public String getColumnFieldName() {
        return this.columnFieldName;
    }

    public void setColumnFieldName(String columnFieldName) {
        this.columnFieldName = columnFieldName;
    }

    public FieldMapperAnnotation getFieldMapperAnnotation() {
        return this.fieldMapperAnnotation;
    }

    public void setFieldMapperAnnotation(FieldMapperAnnotation fieldMapperAnnotation) {
        this.fieldMapperAnnotation = fieldMapperAnnotation;
    }

    public Column getColumn() {
        return this.column;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public Id getId() {
        return this.id;
    }

    public void setId(Id id) {
        this.id = id;
    }

    public OpLockType getOpLockType() {
        return this.opLockType;
    }

    public void setOpLockType(OpLockType opLockType) {
        this.opLockType = opLockType;
    }

    public String[] getIgnoreTag() {
        return this.ignoreTag;
    }

    public void setIgnoreTag(String[] ignoreTag) {
        this.ignoreTag = ignoreTag;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public boolean isInsertAble() {
        return this.insertAble;
    }

    public void setInsertAble(boolean insertAble) {
        this.insertAble = insertAble;
    }

    public boolean isUpdateAble() {
        return this.updateAble;
    }

    public void setUpdateAble(boolean updateAble) {
        this.updateAble = updateAble;
    }

    @Override
    public Class<?> getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(Class<?> fieldType) {
        this.fieldType = fieldType;
    }

    @Override
    public Class<?> getSubTarget() {
        return this.subTarget;
    }

    @Override
    public String getDbCrossedAssociationUniqueKey() {
        return this.dbCrossedAssociationUniqueKey;
    }

    public void setDbCrossedAssociationUniqueKey(String dbCrossedAssociationUniqueKey) {
        this.dbCrossedAssociationUniqueKey = dbCrossedAssociationUniqueKey;
    }

    @Override
    public boolean isCrossDbForeignKey() {
        return this.isCrossDbForeignKey;
    }

    public void setCrossDbForeignKey(boolean isCrossDbForeignKey) {
        this.isCrossDbForeignKey = isCrossDbForeignKey;
    }

    @Override
    public AssociationType getAssociationType() {
        return this.associationType;
    }

    public void setAssociationType(AssociationType associationType) {
        this.associationType = associationType;
    }
}

