/*
 * Decompiled with CFR 0.152.
 */
package indi.mybatis.flying.interceptors;

import com.alibaba.fastjson.JSON;
import indi.mybatis.flying.cache.CacheKeysPool;
import indi.mybatis.flying.cache.EnhancedCachingManager;
import indi.mybatis.flying.cache.EnhancedCachingManagerImpl;
import indi.mybatis.flying.models.Conditionable;
import indi.mybatis.flying.models.FlyingModel;
import indi.mybatis.flying.models.Limitable;
import indi.mybatis.flying.models.Sortable;
import indi.mybatis.flying.utils.CookOriginalSql;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.cache.TransactionalCacheManager;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.factory.DefaultObjectFactory;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.DefaultObjectWrapperFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;

@Intercepts(value={@Signature(args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}, method="query", type=Executor.class), @Signature(args={MappedStatement.class, Object.class}, method="update", type=Executor.class), @Signature(args={boolean.class}, method="commit", type=Executor.class), @Signature(args={boolean.class}, method="rollback", type=Executor.class), @Signature(args={boolean.class}, method="close", type=Executor.class)})
public class EnhancedCachingInterceptor
implements Interceptor {
    private CacheKeysPool queryCacheOnCommit = new CacheKeysPool();
    private Set<String> updateStatementOnCommit = new HashSet<String>();
    EnhancedCachingManager cachingManager = EnhancedCachingManagerImpl.getInstance();
    private static final ObjectFactory DEFAULT_OBJECT_FACTORY = new DefaultObjectFactory();
    private static final ObjectWrapperFactory DEFAULT_OBJECT_WRAPPER_FACTORY = new DefaultObjectWrapperFactory();
    private static final ReflectorFactory DEFAULT_REFLECTOR_FACTORY = new DefaultReflectorFactory();

    public Object intercept(Invocation invocation) throws Throwable {
        String name = invocation.getMethod().getName();
        Object result = null;
        if ("query".equals(name)) {
            result = this.processQuery(invocation);
        } else if ("update".equals(name)) {
            result = this.processUpdate(invocation);
        } else if ("commit".equals(name)) {
            result = this.processCommit(invocation);
        } else if ("rollback".equals(name)) {
            result = this.processRollback(invocation);
        } else if ("close".equals(name)) {
            result = this.processClose(invocation);
        }
        return result;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    protected Object processQuery(Invocation invocation) throws Throwable {
        Object result = invocation.proceed();
        if (this.cachingManager.isCacheEnabled()) {
            Object[] args = invocation.getArgs();
            MappedStatement mappedStatement = (MappedStatement)args[0];
            if (mappedStatement.isFlushCacheRequired()) {
                this.queryCacheOnCommit.clear();
            }
            if (mappedStatement.isUseCache() && mappedStatement.getCache() != null) {
                this.cachingManager.appendStatementCacheMap(mappedStatement.getId(), mappedStatement.getCache());
            }
            Object parameter = args[1];
            RowBounds rowBounds = (RowBounds)args[2];
            Executor executor = (Executor)invocation.getTarget();
            BoundSql boundSql = mappedStatement.getBoundSql(parameter);
            FlyingModel flyingModel = CookOriginalSql.fetchFlyingFeature(boundSql.getSql());
            CacheKey cacheKey = this.createCacheKey(mappedStatement, parameter, rowBounds, boundSql, executor);
            if (flyingModel.isHasFlyingFeature()) {
                switch (flyingModel.getActionType()) {
                    case count: {
                        cacheKey.update((Object)DigestUtils.md5Hex((String)JSON.toJSONString((Object)parameter)));
                        break;
                    }
                    case selectAll: {
                        cacheKey.update((Object)DigestUtils.md5Hex((String)JSON.toJSONString((Object)parameter)));
                        break;
                    }
                    case selectOne: {
                        cacheKey.update((Object)DigestUtils.md5Hex((String)JSON.toJSONString((Object)parameter)));
                        break;
                    }
                }
            }
            this.queryCacheOnCommit.putElement(mappedStatement.getId(), cacheKey);
            ResultHandler resultHandler = (ResultHandler)args[3];
            Executor executorProxy = (Executor)invocation.getTarget();
            MetaObject metaParameter = MetaObject.forObject((Object)parameter, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
            MetaObject metaExecutor = MetaObject.forObject((Object)executorProxy, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
            Cache cache = mappedStatement.getCache();
            Object value = cache.getObject((Object)cacheKey);
            if (metaExecutor.hasGetter("delegate")) {
                TransactionalCacheManager tcm = (TransactionalCacheManager)metaExecutor.getValue("tcm");
                Executor delegate = (Executor)metaExecutor.getValue("delegate");
                List list = delegate.query(mappedStatement, parameter, rowBounds, resultHandler, cacheKey, boundSql);
                if (value != null) {
                    return value;
                }
                tcm.putObject(cache, cacheKey, (Object)list);
                return list;
            }
        }
        return result;
    }

    protected Object processUpdate(Invocation invocation) throws Throwable {
        Object result = invocation.proceed();
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        this.updateStatementOnCommit.add(mappedStatement.getId());
        return result;
    }

    protected Object processCommit(Invocation invocation) throws Throwable {
        Object result = invocation.proceed();
        this.refreshCache();
        return result;
    }

    protected Object processRollback(Invocation invocation) throws Throwable {
        Object result = invocation.proceed();
        this.clearSessionData();
        return result;
    }

    protected Object processClose(Invocation invocation) throws Throwable {
        Object result = invocation.proceed();
        boolean forceRollback = (Boolean)invocation.getArgs()[0];
        if (forceRollback) {
            this.clearSessionData();
        } else {
            this.refreshCache();
        }
        return result;
    }

    private synchronized void clearSessionData() {
        this.queryCacheOnCommit.clear();
        this.updateStatementOnCommit.clear();
    }

    private synchronized void refreshCache() {
        this.cachingManager.refreshCacheKey(this.queryCacheOnCommit);
        this.cachingManager.clearRelatedCaches(this.updateStatementOnCommit);
        this.clearSessionData();
    }

    public void setProperties(Properties properties) {
        if (!this.cachingManager.isInitialized()) {
            this.cachingManager.initialize(properties);
        }
    }

    private CacheKey createCacheKey(MappedStatement mappedStatement, Object parameter, RowBounds rowBounds, BoundSql boundSql, Executor executor) {
        MetaObject metaObject = MetaObject.forObject((Object)parameter, (ObjectFactory)DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)DEFAULT_REFLECTOR_FACTORY);
        if (metaObject.getOriginalObject() instanceof Conditionable) {
            Limitable limiter;
            Sortable sorter;
            CacheKey cacheKey = new CacheKey();
            cacheKey.update((Object)mappedStatement.getId());
            cacheKey.update((Object)rowBounds.getOffset());
            cacheKey.update((Object)rowBounds.getLimit());
            List parameterMappings = boundSql.getParameterMappings();
            cacheKey.update((Object)boundSql.getSql());
            if (parameterMappings.size() > 0 && parameter != null) {
                TypeHandlerRegistry typeHandlerRegistry = mappedStatement.getConfiguration().getTypeHandlerRegistry();
                if (typeHandlerRegistry.hasTypeHandler(parameter.getClass())) {
                    cacheKey.update(parameter);
                } else {
                    for (ParameterMapping parameterMapping : parameterMappings) {
                        String propertyName = parameterMapping.getProperty();
                        if (metaObject.hasGetter(propertyName)) {
                            cacheKey.update(metaObject.getValue(propertyName));
                            continue;
                        }
                        if (!boundSql.hasAdditionalParameter(propertyName)) continue;
                        cacheKey.update(boundSql.getAdditionalParameter(propertyName));
                    }
                }
            }
            if ((sorter = ((Conditionable)metaObject.getOriginalObject()).getSorter()) != null) {
                cacheKey.update((Object)sorter.toSql());
            }
            if ((limiter = ((Conditionable)metaObject.getOriginalObject()).getLimiter()) != null) {
                cacheKey.update((Object)limiter.getPageNo());
                cacheKey.update((Object)limiter.getPageSize());
            }
            return cacheKey;
        }
        return executor.createCacheKey(mappedStatement, parameter, rowBounds, boundSql);
    }
}

