/*
 * Decompiled with CFR 0.152.
 */
package indi.mybatis.flying.cache;

import indi.mybatis.flying.annotations.CacheAnnotation;
import indi.mybatis.flying.annotations.CacheRoleAnnotation;
import indi.mybatis.flying.cache.CacheKeysPool;
import indi.mybatis.flying.cache.ClassComparator;
import indi.mybatis.flying.cache.EnhancedCachingManager;
import indi.mybatis.flying.utils.ReflectHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.ibatis.cache.Cache;

public class EnhancedCachingManagerImpl
implements EnhancedCachingManager {
    private Map<String, Set<String>> observers = new ConcurrentHashMap<String, Set<String>>();
    private Map<Class<?>, Set<Method>> triggerMethods = new ConcurrentHashMap();
    private ConcurrentSkipListMap<Class<?>, Set<Method>> observerMethods = new ConcurrentSkipListMap(new ClassComparator());
    private ConcurrentSkipListMap<Class<?>, Set<Method>> observerMethodsNew = new ConcurrentSkipListMap(new ClassComparator());
    private Map<Class<?>, Set<Class<?>>> observerClasses = new ConcurrentHashMap();
    private Map<Class<?>, Set<Class<?>>> triggerClasses = new ConcurrentHashMap();
    private Map<Class<?>, Set<Class<?>>> observersClassesNew = new ConcurrentHashMap();
    private CacheKeysPool sharedCacheKeysPool = new CacheKeysPool();
    private Map<String, Cache> holds = new ConcurrentHashMap<String, Cache>();
    private boolean initialized = false;
    private boolean cacheEnabled = false;
    private static EnhancedCachingManagerImpl enhancedCacheManager;

    private EnhancedCachingManagerImpl() {
    }

    public static EnhancedCachingManagerImpl getInstance() {
        return enhancedCacheManager == null ? (enhancedCacheManager = new EnhancedCachingManagerImpl()) : enhancedCacheManager;
    }

    @Override
    public void refreshCacheKey(CacheKeysPool keysPool) {
        this.sharedCacheKeysPool.putAll(keysPool);
    }

    @Override
    public void clearRelatedCaches(Set<String> set) {
        for (String observable : set) {
            Set<String> relatedStatements = this.observers.get(observable);
            if (relatedStatements != null) {
                for (String statementId : relatedStatements) {
                    Cache cache = this.holds.get(statementId);
                    Set<Object> cacheKeys = this.sharedCacheKeysPool.get(statementId);
                    for (Object cacheKey : cacheKeys) {
                        cache.removeObject(cacheKey);
                    }
                }
            }
            this.sharedCacheKeysPool.remove(observable);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void initialize(Properties properties) {
        this.initialized = true;
        String cacheEnabled = properties.getProperty("cacheEnabled", "true");
        if ("true".equals(cacheEnabled)) {
            this.cacheEnabled = true;
        }
        String annotationPackages = properties.getProperty("annotationPackage");
        String[] annotationPackageNames = annotationPackages.split(",");
        HashSet classes = new HashSet();
        for (String annotationPackageName : annotationPackageNames) {
            Package annotationPackage = Package.getPackage(annotationPackageName);
            if (annotationPackage == null) continue;
            classes.addAll(ReflectHelper.getClasses(annotationPackageName));
        }
        this.dealPackageInit(classes);
        this.dealObserverClasses(this.observerClasses);
        this.dealPackageInit2(classes);
    }

    private void dealObserverClasses(Map<Class<?>, Set<Class<?>>> m) {
        for (Map.Entry<Class<?>, Set<Class<?>>> e : this.observerClasses.entrySet()) {
            HashSet set = new HashSet();
            this.observerClassesFission(e.getKey(), set);
            this.observersClassesNew.put(e.getKey(), set);
        }
    }

    private void observerClassesFission(Class<?> clazz, Set<Class<?>> set) {
        if (this.observerClasses.containsKey(clazz)) {
            Set<Class<?>> _set = this.observerClasses.get(clazz);
            for (Class<?> e : _set) {
                Class<?> _e = this.getKeyFormValue(e);
                set.add(e);
                if (this.observerClasses.get(_e) == null || this.observerClasses.get(_e).size() <= 0) continue;
                this.observerClassesFission(_e, set);
            }
        }
    }

    private Class<?> getKeyFormValue(Class<?> clazz) {
        for (Map.Entry<Class<?>, Set<Class<?>>> e : this.triggerClasses.entrySet()) {
            if (!e.getValue().contains(clazz)) continue;
            return e.getKey();
        }
        return null;
    }

    private void dealPackageInit(Set<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            Annotation[] classAnnotations;
            for (Annotation an : classAnnotations = clazz.getDeclaredAnnotations()) {
                if (!(an instanceof CacheRoleAnnotation)) continue;
                if (!this.observerClasses.containsKey(clazz)) {
                    this.observerClasses.put(clazz, new HashSet());
                }
                if (!this.triggerClasses.containsKey(clazz)) {
                    this.triggerClasses.put(clazz, new HashSet());
                }
                CacheRoleAnnotation cacheRoleAnnotation = (CacheRoleAnnotation)an;
                for (Class<?> clazz1 : cacheRoleAnnotation.ObserverClass()) {
                    this.observerClasses.get(clazz).add(clazz1);
                }
                for (Class<?> clazz1 : cacheRoleAnnotation.TriggerClass()) {
                    this.triggerClasses.get(clazz).add(clazz1);
                }
            }
        }
    }

    private void dealPackageInit2(Set<Class<?>> classes) {
        for (Class<?> clazz : classes) {
            for (Method method : clazz.getDeclaredMethods()) {
                CacheAnnotation cacheAnnotation = method.getAnnotation(CacheAnnotation.class);
                if (cacheAnnotation == null) continue;
                this.dealPackageInit21(clazz, method, cacheAnnotation);
            }
        }
        this.observerMethodsFission(this.observerMethods, null, this.observerMethodsNew);
        this.buildObservers(this.triggerMethods, this.observerMethodsNew);
    }

    private void dealPackageInit21(Class<?> clazz, Method method, CacheAnnotation cacheAnnotation) {
        switch (cacheAnnotation.role()) {
            case Observer: {
                for (Class<?> clazz1 : this.observersClassesNew.get(clazz)) {
                    if (!this.observerMethods.containsKey(clazz1)) {
                        this.observerMethods.put(clazz1, new HashSet());
                    }
                    this.observerMethods.get(clazz1).add(method);
                }
                break;
            }
            case Trigger: {
                for (Class<?> clazz1 : this.triggerClasses.get(clazz)) {
                    if (!this.triggerMethods.containsKey(clazz1)) {
                        this.triggerMethods.put(clazz1, new HashSet());
                    }
                    this.triggerMethods.get(clazz1).add(method);
                }
                break;
            }
        }
    }

    private void observerMethodsFission(ConcurrentSkipListMap<Class<?>, Set<Method>> observerMethodMap, Map.Entry<Class<?>, Set<Method>> currentE, ConcurrentSkipListMap<Class<?>, Set<Method>> observerMethodMapNew) {
        if (observerMethodMap.size() != 0) {
            if (currentE == null) {
                currentE = observerMethodMap.firstEntry();
            }
            observerMethodMapNew.put(currentE.getKey(), currentE.getValue());
            this.observerMethodsFissionFission(observerMethodMap, observerMethodMapNew);
            Map.Entry<Class<?>, Set<Method>> nextE = observerMethodMap.higherEntry(currentE.getKey());
            if (nextE != null) {
                this.observerMethodsFission(observerMethodMap, nextE, observerMethodMapNew);
            }
        }
    }

    private void observerMethodsFissionFission(ConcurrentSkipListMap<Class<?>, Set<Method>> observerMethodMap, ConcurrentSkipListMap<Class<?>, Set<Method>> observerMethodMapNew) {
        LinkedHashSet tempSet = new LinkedHashSet();
        Map.Entry<Class<?>, Set<Method>> lastE = observerMethodMapNew.lastEntry();
        int size1 = lastE.getValue().size();
        for (Method methob : lastE.getValue()) {
            Class<?> clazz;
            if (!"select".equals(methob.getName()) || !observerMethodMap.containsKey(clazz = methob.getReturnType())) continue;
            tempSet.addAll(observerMethodMap.get(clazz));
        }
        lastE.getValue().addAll(tempSet);
        int size2 = lastE.getValue().size();
        if (size1 != size2) {
            this.observerMethodsFissionFission(observerMethodMap, observerMethodMapNew);
        }
    }

    @Override
    public void appendStatementCacheMap(String statementId, Cache cache) {
        if (this.holds.containsKey(statementId) && this.holds.get(statementId) != null) {
            return;
        }
        this.holds.put(statementId, cache);
    }

    @Override
    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    private void buildObservers(Map<Class<?>, Set<Method>> triggerMethodMap, Map<Class<?>, Set<Method>> observerMethodMap) {
        for (Class<?> clazz : triggerMethodMap.keySet()) {
            Set<Method> observerMethods = observerMethodMap.get(clazz);
            if (observerMethods == null) continue;
            for (Method triggerMethod : triggerMethodMap.get(clazz)) {
                String triggerFullName = triggerMethod.getDeclaringClass().getName() + "." + triggerMethod.getName();
                if (!this.observers.containsKey(triggerFullName)) {
                    this.observers.put(triggerFullName, new HashSet());
                }
                for (Method observerMethod : observerMethods) {
                    String observerFullName = observerMethod.getDeclaringClass().getName() + "." + observerMethod.getName();
                    this.observers.get(triggerFullName).add(observerFullName);
                }
            }
        }
    }
}

