/*
 * Decompiled with CFR 0.152.
 */
package indi.mybatis.flying.cache;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CacheKeysPool {
    private Map<String, Set<Object>> pool = new ConcurrentHashMap<String, Set<Object>>();

    public Set<Object> get(String key) {
        if (this.pool.get(key) == null) {
            this.pool.put(key, new HashSet());
        }
        return this.pool.get(key);
    }

    public Set<Object> put(String key, Set<Object> value) {
        return this.pool.put(key, value);
    }

    public void putElement(String key, Object element) {
        if (this.pool.get(key) == null) {
            this.pool.put(key, new HashSet());
        }
        this.pool.get(key).add(element);
    }

    public Set<Object> remove(String key) {
        return this.pool.remove(key);
    }

    public void clear() {
        this.pool.clear();
    }

    public Set<String> keySet() {
        return this.pool.keySet();
    }

    public Map<String, Set<Object>> getOriginalPool() {
        return this.pool;
    }

    public Set<Map.Entry<String, Set<Object>>> entrySet() {
        return this.pool.entrySet();
    }

    public void putAll(CacheKeysPool pool) {
        for (Map.Entry<String, Set<Object>> entry : pool.entrySet()) {
            for (Object item : entry.getValue()) {
                this.putElement(entry.getKey(), item);
            }
        }
    }
}

