/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.retry;

import com.github.lianjiatech.retrofit.spring.boot.retry.Retry;
import com.github.lianjiatech.retrofit.spring.boot.retry.RetryRule;
import java.io.IOException;
import java.lang.reflect.Method;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Invocation;

public abstract class BaseRetryInterceptor
implements Interceptor {
    private static final int LIMIT_RETRIES = 10;

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Retry retry;
        Request request = chain.request();
        Invocation invocation = (Invocation)request.tag(Invocation.class);
        assert (invocation != null);
        Method method = invocation.method();
        if (method.isAnnotationPresent(Retry.class)) {
            retry = method.getAnnotation(Retry.class);
        } else {
            Class<?> declaringClass = method.getDeclaringClass();
            retry = declaringClass.getAnnotation(Retry.class);
        }
        if (retry == null) {
            return chain.proceed(request);
        }
        int maxRetries = retry.maxRetries();
        int intervalMs = retry.intervalMs();
        RetryRule[] retryRules = retry.retryRules();
        maxRetries = maxRetries > 10 ? 10 : maxRetries;
        try {
            return this.retryIntercept(maxRetries, intervalMs, retryRules, chain);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract Response retryIntercept(int var1, int var2, RetryRule[] var3, Interceptor.Chain var4) throws IOException, InterruptedException;
}

