/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.degrade;

import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.github.lianjiatech.retrofit.spring.boot.config.RetrofitProperties;
import com.github.lianjiatech.retrofit.spring.boot.degrade.DegradeStrategy;
import com.github.lianjiatech.retrofit.spring.boot.degrade.DegradeType;
import com.github.lianjiatech.retrofit.spring.boot.degrade.RetrofitDegradeRule;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class RetrofitDegradeRuleInitializer
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger logger = LoggerFactory.getLogger(RetrofitDegradeRuleInitializer.class);
    private final RetrofitProperties retrofitProperties;
    private static List<RetrofitDegradeRule> LIST = new CopyOnWriteArrayList<RetrofitDegradeRule>();

    public RetrofitDegradeRuleInitializer(RetrofitProperties retrofitProperties) {
        this.retrofitProperties = retrofitProperties;
    }

    public static void addRetrofitDegradeRule(RetrofitDegradeRule degradeRule) {
        if (degradeRule == null) {
            return;
        }
        LIST.add(degradeRule);
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        if (!this.retrofitProperties.isEnableDegrade()) {
            return;
        }
        DegradeType degradeType = this.retrofitProperties.getDegradeType();
        switch (degradeType) {
            case SENTINEL: {
                try {
                    Class.forName("com.alibaba.csp.sentinel.SphU");
                    ArrayList<DegradeRule> rules = new ArrayList<DegradeRule>();
                    for (RetrofitDegradeRule degradeRule : LIST) {
                        int grade;
                        DegradeStrategy degradeStrategy = degradeRule.getDegradeStrategy();
                        switch (degradeStrategy) {
                            case AVERAGE_RT: {
                                grade = 0;
                                break;
                            }
                            case EXCEPTION_RATIO: {
                                grade = 1;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Not currently supported! degradeStrategy=" + (Object)((Object)degradeStrategy));
                            }
                        }
                        String resourceName = degradeRule.getResourceName();
                        DegradeRule rule = new DegradeRule().setGrade(grade).setCount(degradeRule.getCount()).setTimeWindow(degradeRule.getTimeWindow());
                        rule.setResource(resourceName);
                        rules.add(rule);
                    }
                    DegradeRuleManager.loadRules(rules);
                }
                catch (Exception e) {
                    logger.warn("com.alibaba.csp.sentinel not found! No SentinelDegradeInterceptor is set.");
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Not currently supported! degradeType=" + (Object)((Object)degradeType));
            }
        }
    }
}

