/*
 * Decompiled with CFR 0.152.
 */
package com.github.lianjiatech.retrofit.spring.boot.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.lianjiatech.retrofit.spring.boot.config.PoolConfig;
import com.github.lianjiatech.retrofit.spring.boot.config.RetrofitConfigBean;
import com.github.lianjiatech.retrofit.spring.boot.config.RetrofitProperties;
import com.github.lianjiatech.retrofit.spring.boot.core.AutoConfiguredRetrofitScannerRegistrar;
import com.github.lianjiatech.retrofit.spring.boot.core.NoValidServiceInstanceChooser;
import com.github.lianjiatech.retrofit.spring.boot.core.PrototypeInterceptorBdfProcessor;
import com.github.lianjiatech.retrofit.spring.boot.core.RetrofitFactoryBean;
import com.github.lianjiatech.retrofit.spring.boot.core.ServiceInstanceChooser;
import com.github.lianjiatech.retrofit.spring.boot.degrade.BaseResourceNameParser;
import com.github.lianjiatech.retrofit.spring.boot.degrade.RetrofitDegradeRuleInitializer;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.BaseGlobalInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.NetworkInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.interceptor.ServiceInstanceChooserInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.retry.BaseRetryInterceptor;
import com.github.lianjiatech.retrofit.spring.boot.util.ApplicationContextUtils;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.converter.jackson.JacksonConverterFactory;

@Configuration
@EnableConfigurationProperties(value={RetrofitProperties.class})
@AutoConfigureAfter(value={JacksonAutoConfiguration.class})
public class RetrofitAutoConfiguration
implements ApplicationContextAware {
    private static final Logger logger = LoggerFactory.getLogger(RetrofitAutoConfiguration.class);
    @Autowired
    private RetrofitProperties retrofitProperties;
    private ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean
    public RetrofitConfigBean retrofitConfigBean() throws IllegalAccessException, InstantiationException {
        ServiceInstanceChooser serviceInstanceChooser;
        RetrofitConfigBean retrofitConfigBean = new RetrofitConfigBean(this.retrofitProperties);
        ConcurrentHashMap<String, ConnectionPool> poolRegistry = new ConcurrentHashMap<String, ConnectionPool>(4);
        Map<String, PoolConfig> pool = this.retrofitProperties.getPool();
        if (pool != null) {
            pool.forEach((poolName, poolConfig) -> {
                long keepAliveSecond = poolConfig.getKeepAliveSecond();
                int maxIdleConnections = poolConfig.getMaxIdleConnections();
                ConnectionPool connectionPool = new ConnectionPool(maxIdleConnections, keepAliveSecond, TimeUnit.SECONDS);
                poolRegistry.put((String)poolName, connectionPool);
            });
        }
        retrofitConfigBean.setPoolRegistry(poolRegistry);
        Class<? extends CallAdapter.Factory>[] globalCallAdapterFactories = this.retrofitProperties.getGlobalCallAdapterFactories();
        retrofitConfigBean.setGlobalCallAdapterFactoryClasses(globalCallAdapterFactories);
        Class<? extends Converter.Factory>[] globalConverterFactories = this.retrofitProperties.getGlobalConverterFactories();
        retrofitConfigBean.setGlobalConverterFactoryClasses(globalConverterFactories);
        Collection<BaseGlobalInterceptor> globalInterceptors = ApplicationContextUtils.getBeans(this.applicationContext, BaseGlobalInterceptor.class);
        retrofitConfigBean.setGlobalInterceptors(globalInterceptors);
        Class<? extends BaseRetryInterceptor> retryInterceptor = this.retrofitProperties.getRetryInterceptor();
        retrofitConfigBean.setRetryInterceptor(retryInterceptor.newInstance());
        Collection<NetworkInterceptor> networkInterceptors = ApplicationContextUtils.getBeans(this.applicationContext, NetworkInterceptor.class);
        retrofitConfigBean.setNetworkInterceptors(networkInterceptors);
        try {
            serviceInstanceChooser = (ServiceInstanceChooser)this.applicationContext.getBean(ServiceInstanceChooser.class);
        }
        catch (BeansException e) {
            serviceInstanceChooser = new NoValidServiceInstanceChooser();
        }
        ServiceInstanceChooserInterceptor serviceInstanceChooserInterceptor = new ServiceInstanceChooserInterceptor(serviceInstanceChooser);
        retrofitConfigBean.setServiceInstanceChooserInterceptor(serviceInstanceChooserInterceptor);
        Class<? extends BaseResourceNameParser> resourceNameParser = this.retrofitProperties.getResourceNameParser();
        retrofitConfigBean.setResourceNameParser(resourceNameParser.newInstance());
        return retrofitConfigBean;
    }

    @Bean
    @ConditionalOnMissingBean
    public ObjectMapper jacksonObjectMapper() {
        return new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @Bean
    @ConditionalOnMissingBean
    @Autowired
    public JacksonConverterFactory jacksonConverterFactory(ObjectMapper objectMapper) {
        return JacksonConverterFactory.create((ObjectMapper)objectMapper);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Bean
    public RetrofitDegradeRuleInitializer retrofitDegradeRuleInitializer() {
        return new RetrofitDegradeRuleInitializer(this.retrofitProperties);
    }

    @Configuration
    @Import(value={AutoConfiguredRetrofitScannerRegistrar.class})
    @ConditionalOnMissingBean(value={RetrofitFactoryBean.class})
    public static class RetrofitScannerRegistrarNotFoundConfiguration
    implements InitializingBean {
        public void afterPropertiesSet() {
            logger.debug("No {} found.", (Object)RetrofitFactoryBean.class.getName());
        }
    }

    @Configuration
    public static class RetrofitProcessorAutoConfiguration {
        @Bean
        public static PrototypeInterceptorBdfProcessor prototypeInterceptorBdfProcessor() {
            return new PrototypeInterceptorBdfProcessor();
        }
    }
}

