/*
 * Decompiled with CFR 0.152.
 */
package com.ijpay.alipay;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.CertAlipayRequest;
import com.alipay.api.DefaultAlipayClient;
import java.io.Serializable;

public class AliPayApiConfig
implements Serializable {
    private static final long serialVersionUID = -4736760736935998953L;
    private String privateKey;
    private String aliPayPublicKey;
    private String appId;
    private String serviceUrl;
    private String charset;
    private String signType;
    private String format;
    private boolean certModel;
    private String appCertPath;
    private String appCertContent;
    private String aliPayCertPath;
    private String aliPayCertContent;
    private String aliPayRootCertPath;
    private String aliPayRootCertContent;
    private AlipayClient alipayClient;
    private Object exParams;
    private String domain;

    private AliPayApiConfig() {
    }

    public static AliPayApiConfig builder() {
        return new AliPayApiConfig();
    }

    public AliPayApiConfig build() {
        this.alipayClient = new DefaultAlipayClient(this.getServiceUrl(), this.getAppId(), this.getPrivateKey(), this.getFormat(), this.getCharset(), this.getAliPayPublicKey(), this.getSignType());
        return this;
    }

    public AliPayApiConfig buildByCert() throws AlipayApiException {
        return this.build(this.getAppCertPath(), this.getAliPayCertPath(), this.getAliPayRootCertPath());
    }

    public AliPayApiConfig buildByCertContent() throws AlipayApiException {
        return this.buildByCertContent(this.getAppCertContent(), this.getAliPayCertContent(), this.getAliPayRootCertContent());
    }

    public AliPayApiConfig build(String appCertPath, String aliPayCertPath, String aliPayRootCertPath) throws AlipayApiException {
        CertAlipayRequest certAlipayRequest = new CertAlipayRequest();
        certAlipayRequest.setServerUrl(this.getServiceUrl());
        certAlipayRequest.setAppId(this.getAppId());
        certAlipayRequest.setPrivateKey(this.getPrivateKey());
        certAlipayRequest.setFormat(this.getFormat());
        certAlipayRequest.setCharset(this.getCharset());
        certAlipayRequest.setSignType(this.getSignType());
        certAlipayRequest.setCertPath(appCertPath);
        certAlipayRequest.setAlipayPublicCertPath(aliPayCertPath);
        certAlipayRequest.setRootCertPath(aliPayRootCertPath);
        this.alipayClient = new DefaultAlipayClient(certAlipayRequest);
        this.certModel = true;
        return this;
    }

    public AliPayApiConfig buildByCertContent(String appCertContent, String aliPayCertContent, String aliPayRootCertContent) throws AlipayApiException {
        CertAlipayRequest certAlipayRequest = new CertAlipayRequest();
        certAlipayRequest.setServerUrl(this.getServiceUrl());
        certAlipayRequest.setAppId(this.getAppId());
        certAlipayRequest.setPrivateKey(this.getPrivateKey());
        certAlipayRequest.setFormat(this.getFormat());
        certAlipayRequest.setCharset(this.getCharset());
        certAlipayRequest.setSignType(this.getSignType());
        certAlipayRequest.setCertContent(appCertContent);
        certAlipayRequest.setAlipayPublicCertContent(aliPayCertContent);
        certAlipayRequest.setRootCertContent(aliPayRootCertContent);
        this.alipayClient = new DefaultAlipayClient(certAlipayRequest);
        this.certModel = true;
        return this;
    }

    public String getPrivateKey() {
        if (StrUtil.isBlank((CharSequence)this.privateKey)) {
            throw new IllegalStateException("privateKey \u672a\u88ab\u8d4b\u503c");
        }
        return this.privateKey;
    }

    public AliPayApiConfig setPrivateKey(String privateKey) {
        if (StrUtil.isEmpty((CharSequence)privateKey)) {
            throw new IllegalArgumentException("privateKey \u503c\u4e0d\u80fd\u4e3a null");
        }
        this.privateKey = privateKey;
        return this;
    }

    public String getAliPayPublicKey() {
        return this.aliPayPublicKey;
    }

    public AliPayApiConfig setAliPayPublicKey(String aliPayPublicKey) {
        this.aliPayPublicKey = aliPayPublicKey;
        return this;
    }

    public String getAppId() {
        if (StrUtil.isEmpty((CharSequence)this.appId)) {
            throw new IllegalStateException("appId \u672a\u88ab\u8d4b\u503c");
        }
        return this.appId;
    }

    public AliPayApiConfig setAppId(String appId) {
        if (StrUtil.isEmpty((CharSequence)appId)) {
            throw new IllegalArgumentException("appId \u503c\u4e0d\u80fd\u4e3a null");
        }
        this.appId = appId;
        return this;
    }

    public String getServiceUrl() {
        if (StrUtil.isEmpty((CharSequence)this.serviceUrl)) {
            throw new IllegalStateException("serviceUrl \u672a\u88ab\u8d4b\u503c");
        }
        return this.serviceUrl;
    }

    public AliPayApiConfig setServiceUrl(String serviceUrl) {
        if (StrUtil.isEmpty((CharSequence)serviceUrl)) {
            serviceUrl = "https://openapi.alipay.com/gateway.do";
        }
        this.serviceUrl = serviceUrl;
        return this;
    }

    public String getCharset() {
        if (StrUtil.isEmpty((CharSequence)this.charset)) {
            this.charset = "UTF-8";
        }
        return this.charset;
    }

    public AliPayApiConfig setCharset(String charset) {
        if (StrUtil.isEmpty((CharSequence)charset)) {
            charset = "UTF-8";
        }
        this.charset = charset;
        return this;
    }

    public String getSignType() {
        if (StrUtil.isEmpty((CharSequence)this.signType)) {
            this.signType = "RSA2";
        }
        return this.signType;
    }

    public AliPayApiConfig setSignType(String signType) {
        if (StrUtil.isEmpty((CharSequence)signType)) {
            signType = "RSA2";
        }
        this.signType = signType;
        return this;
    }

    public String getFormat() {
        if (StrUtil.isEmpty((CharSequence)this.format)) {
            this.format = "json";
        }
        return this.format;
    }

    public String getAppCertPath() {
        return this.appCertPath;
    }

    public AliPayApiConfig setAppCertPath(String appCertPath) {
        this.appCertPath = appCertPath;
        return this;
    }

    public String getAppCertContent() {
        return this.appCertContent;
    }

    public AliPayApiConfig setAppCertContent(String appCertContent) {
        this.appCertContent = appCertContent;
        return this;
    }

    public String getAliPayCertPath() {
        return this.aliPayCertPath;
    }

    public AliPayApiConfig setAliPayCertPath(String aliPayCertPath) {
        this.aliPayCertPath = aliPayCertPath;
        return this;
    }

    public String getAliPayCertContent() {
        return this.aliPayCertContent;
    }

    public AliPayApiConfig setAliPayCertContent(String aliPayCertContent) {
        this.aliPayCertContent = aliPayCertContent;
        return this;
    }

    public String getAliPayRootCertPath() {
        return this.aliPayRootCertPath;
    }

    public AliPayApiConfig setAliPayRootCertPath(String aliPayRootCertPath) {
        this.aliPayRootCertPath = aliPayRootCertPath;
        return this;
    }

    public String getAliPayRootCertContent() {
        return this.aliPayRootCertContent;
    }

    public AliPayApiConfig setAliPayRootCertContent(String aliPayRootCertContent) {
        this.aliPayRootCertContent = aliPayRootCertContent;
        return this;
    }

    public boolean isCertModel() {
        return this.certModel;
    }

    public AliPayApiConfig setCertModel(boolean certModel) {
        this.certModel = certModel;
        return this;
    }

    public AlipayClient getAliPayClient() {
        if (this.alipayClient == null) {
            throw new IllegalStateException("aliPayClient \u672a\u88ab\u521d\u59cb\u5316");
        }
        return this.alipayClient;
    }

    public Object getExParams() {
        return this.exParams;
    }

    public AliPayApiConfig setExParams(Object exParams) {
        this.exParams = exParams;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public AliPayApiConfig setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public String toString() {
        return JSONUtil.toJsonStr((Object)this);
    }
}

