/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.nlp.common.dfa.tree.impl;

import com.github.houbb.heaven.util.guava.Guavas;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import com.github.houbb.heaven.util.util.MapUtil;
import com.github.houbb.nlp.common.dfa.tree.ITrieTreeMap;
import com.github.houbb.nlp.common.dfa.tree.impl.DefaultTrieTreeMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractTrieTreeMap
implements ITrieTreeMap {
    protected abstract Map getStaticVolatileMap();

    protected abstract Collection<String> getWordCollection();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map getTrieTreeMap() {
        Map innerWordMap = this.getStaticVolatileMap();
        if (MapUtil.isNotEmpty((Map)innerWordMap)) {
            return innerWordMap;
        }
        Class<AbstractTrieTreeMap> clazz = AbstractTrieTreeMap.class;
        synchronized (AbstractTrieTreeMap.class) {
            if (MapUtil.isEmpty((Map)innerWordMap)) {
                long startTime = System.currentTimeMillis();
                Collection<String> allLines = this.getWordCollection();
                Set wordSet = Guavas.newHashSet();
                for (String line : allLines) {
                    if (StringUtil.isEmpty((String)line)) continue;
                    String[] strings = line.split(" ");
                    wordSet.add(strings[0]);
                }
                this.initInnerWordMap(wordSet, innerWordMap);
                long endTime = System.currentTimeMillis();
                System.out.println("[NLP] trie map loaded cost time " + (endTime - startTime) + " ms!");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return innerWordMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITrieTreeMap add(String word) {
        Map innerWordMap = this.getStaticVolatileMap();
        if (MapUtil.isEmpty((Map)innerWordMap)) {
            this.getTrieTreeMap();
        }
        Class<DefaultTrieTreeMap> clazz = DefaultTrieTreeMap.class;
        synchronized (DefaultTrieTreeMap.class) {
            this.initInnerWordMap(word, innerWordMap);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this;
        }
    }

    @Override
    public ITrieTreeMap clear() {
        Map map = this.getStaticVolatileMap();
        if (ObjectUtil.isNotNull((Object)map)) {
            map.clear();
        }
        return this;
    }

    private void initInnerWordMap(Collection<String> wordCollection, Map innerWordMap) {
        if (CollectionUtil.isEmpty(wordCollection)) {
            return;
        }
        for (String key : wordCollection) {
            this.initInnerWordMap(key, innerWordMap);
        }
    }

    private void initInnerWordMap(String word, Map innerWordMap) {
        if (StringUtil.isEmpty((String)word)) {
            return;
        }
        char[] chars = word.toCharArray();
        int size = chars.length;
        HashMap<Object, Serializable> currentMap = innerWordMap;
        for (int i = 0; i < size; ++i) {
            char charKey = chars[i];
            Object wordMap = currentMap.get(Character.valueOf(charKey));
            if (ObjectUtil.isNotNull(wordMap)) {
                currentMap = (Map)wordMap;
            } else {
                HashMap<Object, Serializable> newWordMap = new HashMap<Object, Serializable>(8);
                newWordMap.put("ED", Boolean.valueOf(false));
                currentMap.put(Character.valueOf(charKey), newWordMap);
                currentMap = newWordMap;
            }
            if (i != size - 1) continue;
            currentMap.put("ED", Boolean.valueOf(true));
        }
    }
}

