/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl;

import com.github.fakemongo.impl.ExpressionParser;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.LazyDBList;
import com.mongodb.gridfs.GridFSFile;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.bson.BSON;
import org.bson.LazyBSONList;
import org.bson.LazyBSONObject;
import org.bson.types.Binary;

public final class Util {
    private Util() {
    }

    public static <T> BasicDBList list(T ... ts) {
        return Util.wrap(Arrays.asList(ts));
    }

    public static <T> T extractField(DBObject object, String field) {
        Object value;
        if (object == null) {
            return null;
        }
        int indexDot = field.indexOf(46);
        if (indexDot > 0) {
            String subField = field.substring(indexDot + 1);
            value = Util.extractField(ExpressionParser.toDbObject(object.get(field.substring(0, indexDot))), subField);
        } else {
            value = object.get(field);
        }
        return (T)value;
    }

    public static <T> T extractField(DBObject object, List<String> paths) {
        String path;
        if (object == null) {
            return null;
        }
        DBObject value = object;
        Iterator<String> iterator = paths.iterator();
        while (iterator.hasNext() && (value = ExpressionParser.toDbObject(value.get(path = iterator.next()))) != null) {
        }
        return (T)value;
    }

    public static boolean containsField(DBObject object, String field) {
        boolean result;
        if (object == null) {
            return false;
        }
        int indexDot = field.indexOf(46);
        if (indexDot > 0) {
            Object value;
            String subField = field.substring(indexDot + 1);
            String actualField = field.substring(0, indexDot);
            result = false;
            if (object.containsField(actualField) && ExpressionParser.isDbObject(value = object.get(actualField))) {
                result = Util.containsField(ExpressionParser.toDbObject(value), subField);
            }
        } else {
            result = object.containsField(field);
        }
        return result;
    }

    public static void removeField(DBObject object, String field) {
        if (object == null) {
            return;
        }
        int indexDot = field.indexOf(46);
        if (indexDot > 0) {
            Object value;
            String subField = field.substring(indexDot + 1);
            String actualField = field.substring(0, indexDot);
            if (object.containsField(actualField) && ExpressionParser.isDbObject(value = object.get(actualField))) {
                Util.removeField(ExpressionParser.toDbObject(value), subField);
            }
        } else {
            object.removeField(field);
        }
    }

    public static void putValue(DBObject dbObject, String path, Object value) {
        if (dbObject == null) {
            return;
        }
        int indexDot = path.indexOf(46);
        if (indexDot > 0) {
            String field = path.substring(0, indexDot);
            String nextPath = path.substring(indexDot + 1);
            if (!dbObject.containsField(field)) {
                dbObject.put(field, (Object)new BasicDBObject());
            }
            Util.putValue(ExpressionParser.toDbObject(dbObject.get(field)), nextPath, value);
        } else {
            dbObject.put(path, value);
        }
    }

    public static BasicDBList wrap(List otherList) {
        BasicDBList list = new BasicDBList();
        list.addAll((Collection)otherList);
        return list;
    }

    public static List<String> split(String key) {
        int dot = 46;
        int index = key.indexOf(dot);
        if (index <= 0) {
            return Collections.singletonList(key);
        }
        ArrayList<String> path = new ArrayList<String>(5);
        while (index > 0) {
            path.add(key.substring(0, index));
            key = key.substring(index + 1);
            index = key.indexOf(dot);
        }
        path.add(key);
        return path;
    }

    public static boolean isPositiveInt(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static int compareToNullable(String s1, String s2) {
        if (s1 == null) {
            if (s2 == null) {
                return 0;
            }
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    public static Object clone(Object source) {
        if ((source = BSON.applyEncodingHooks((Object)source)) instanceof UUID) {
            return source;
        }
        if (ExpressionParser.isDbObject(source)) {
            return Util.clone(ExpressionParser.toDbObject(source));
        }
        if (source instanceof Binary) {
            return ((Binary)source).getData().clone();
        }
        if (source instanceof Date) {
            return new Date(((Date)source).getTime());
        }
        if (source instanceof Character) {
            return source.toString();
        }
        if (source instanceof Number) {
            Number n = (Number)source;
            if (n instanceof Integer || n instanceof Short || n instanceof Byte || n instanceof AtomicInteger) {
                return n.intValue();
            }
            if (n instanceof Long || n instanceof AtomicLong) {
                return n.longValue();
            }
            if (n instanceof Float || n instanceof Double) {
                return n.doubleValue();
            }
            throw new IllegalArgumentException("can't serialize " + n.getClass());
        }
        if (source instanceof byte[]) {
            return Util.makeCopy((byte[])source);
        }
        return source;
    }

    private static byte[] makeCopy(byte[] source) {
        if (source == null) {
            return null;
        }
        byte[] copy = new byte[source.length];
        System.arraycopy(source, 0, copy, 0, source.length);
        return copy;
    }

    public static <T extends DBObject> T clone(T source) {
        if (source == null) {
            return null;
        }
        if (source instanceof BasicDBList) {
            DBObject clone = (DBObject)((BasicDBList)source).copy();
            return (T)clone;
        }
        if (source instanceof LazyBSONList) {
            BasicDBList clone = new BasicDBList();
            for (Object o : (LazyBSONList)source) {
                if (o instanceof DBObject) {
                    clone.add((Object)Util.clone(ExpressionParser.toDbObject(o)));
                    continue;
                }
                clone.add(o);
            }
            return (T)clone;
        }
        if (source instanceof LazyDBList) {
            BasicDBList clone = new BasicDBList();
            for (Object o : (LazyDBList)source) {
                if (ExpressionParser.isDbObject(o)) {
                    clone.add((Object)Util.clone(ExpressionParser.toDbObject(o)));
                    continue;
                }
                clone.add(o);
            }
            return (T)clone;
        }
        if (source instanceof BasicDBObject) {
            DBObject clone = (DBObject)((BasicDBObject)source).copy();
            return (T)clone;
        }
        if (source instanceof LazyBSONObject) {
            BasicDBObject clone = new BasicDBObject();
            for (Map.Entry entry : ((LazyBSONObject)source).entrySet()) {
                if (ExpressionParser.isDbObject(entry.getValue())) {
                    clone.put(entry.getKey(), (Object)Util.clone(ExpressionParser.toDbObject(entry.getValue())));
                    continue;
                }
                if (entry.getValue() instanceof Binary) {
                    clone.put(entry.getKey(), ((Binary)entry.getValue()).getData().clone());
                    continue;
                }
                clone.put(entry.getKey(), entry.getValue());
            }
            return (T)clone;
        }
        BasicDBObject clone = new BasicDBObject();
        for (Map.Entry<String, Object> entry : Util.entrySet(source)) {
            if (ExpressionParser.isDbObject(entry.getValue())) {
                clone.put((Object)entry.getKey(), (Object)Util.clone(ExpressionParser.toDbObject(entry.getValue())));
                continue;
            }
            if (entry.getValue() instanceof Binary) {
                clone.put((Object)entry.getKey(), ((Binary)entry.getValue()).getData().clone());
                continue;
            }
            clone.put((Object)entry.getKey(), entry.getValue());
        }
        return (T)clone;
    }

    public static Set<Map.Entry<String, Object>> entrySet(DBObject object) {
        return object.toMap().entrySet();
    }

    public static DBObject cloneIdFirst(DBObject source) {
        Set entrySet;
        if (source == null) {
            return null;
        }
        BasicDBObject newobj = new BasicDBObject();
        if (source.containsField("_id")) {
            newobj.put("_id", source.get("_id"));
        }
        if (source instanceof LazyBSONObject) {
            entrySet = ((LazyBSONObject)source).entrySet();
        } else if (source instanceof GridFSFile) {
            HashMap<String, Object> copyMap = new HashMap<String, Object>();
            for (String field : source.keySet()) {
                copyMap.put(field, source.get(field));
            }
            entrySet = copyMap.entrySet();
        } else {
            entrySet = source.toMap().entrySet();
        }
        for (Map.Entry entry : entrySet) {
            String field;
            field = (String)entry.getKey();
            if ("_id".equals(field)) continue;
            Object val = entry.getValue();
            if (ExpressionParser.isDbObject(val)) {
                newobj.put(field, (Object)Util.clone(ExpressionParser.toDbObject(val)));
                continue;
            }
            newobj.put(field, Util.clone(val));
        }
        return newobj;
    }

    public static boolean isDBObjectEmpty(DBObject projection) {
        return projection == null || projection.keySet().isEmpty();
    }

    public static Collection toCollection(Object array) {
        int length = Array.getLength(array);
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < length; ++i) {
            list.add(Array.get(array, i));
        }
        return list;
    }

    public static List toList(Collection expression) {
        if (expression instanceof List) {
            return (List)expression;
        }
        ArrayList list = new ArrayList();
        for (Object object : expression) {
            list.add(object);
        }
        return list;
    }

    public static Number genericAdd(Number left, Number right) {
        if (left instanceof Float || left instanceof Double || right instanceof Float || right instanceof Double) {
            return left.doubleValue() + right.doubleValue();
        }
        if (left instanceof Integer && right instanceof Integer) {
            return left.intValue() + right.intValue();
        }
        return left.longValue() + right.longValue();
    }

    public static Number genericSub(Number left, Number right) {
        if (left instanceof Float || left instanceof Double || right instanceof Float || right instanceof Double) {
            return left.doubleValue() - right.doubleValue();
        }
        if (left instanceof Integer && right instanceof Integer) {
            return left.intValue() - right.intValue();
        }
        return left.longValue() - right.longValue();
    }

    public static Number genericMul(Number left, Number right) {
        if (left instanceof Float || left instanceof Double || right instanceof Float || right instanceof Double) {
            return left.doubleValue() * right.doubleValue();
        }
        if (left instanceof Integer && right instanceof Integer) {
            return left.intValue() * right.intValue();
        }
        return left.longValue() * right.longValue();
    }

    public static Number genericDiv(Number left, Number right) {
        if (left instanceof Float || left instanceof Double || right instanceof Float || right instanceof Double) {
            return left.doubleValue() / right.doubleValue();
        }
        if (left instanceof Integer && right instanceof Integer) {
            return left.intValue() / right.intValue();
        }
        return left.longValue() / right.longValue();
    }

    public static Number genericMod(Number left, Number right) {
        if (left instanceof Float || left instanceof Double || right instanceof Float || right instanceof Double) {
            return left.doubleValue() % right.doubleValue();
        }
        if (left instanceof Integer && right instanceof Integer) {
            return left.intValue() % right.intValue();
        }
        return left.longValue() % right.longValue();
    }

    public static Number genericMax(Number left, Number right) {
        if (left instanceof Float || left instanceof Double || right instanceof Float || right instanceof Double) {
            return Math.max(left.doubleValue(), right.doubleValue());
        }
        if (left instanceof Integer && right instanceof Integer) {
            return Math.max(left.intValue(), right.intValue());
        }
        return Math.max(left.longValue(), right.longValue());
    }

    public static Date genericMax(Date left, Date right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return left.after(right) ? left : right;
    }

    public static Number genericMin(Number left, Number right) {
        if (left instanceof Float || left instanceof Double || right instanceof Float || right instanceof Double) {
            return Math.min(left.doubleValue(), right.doubleValue());
        }
        if (left instanceof Integer && right instanceof Integer) {
            return Math.min(left.intValue(), right.intValue());
        }
        return Math.min(left.longValue(), right.longValue());
    }

    public static Date genericMin(Date left, Date right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        return left.before(right) ? left : right;
    }
}

