/*
 * Decompiled with CFR 0.152.
 */
package com.github.cb372.metrics.sigar;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.github.cb372.metrics.sigar.AbstractSigarMetric;
import org.hyperic.sigar.ResourceLimit;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class UlimitMetrics
extends AbstractSigarMetric {
    private final long infinity = ResourceLimit.INFINITY();

    protected UlimitMetrics(Sigar sigar) {
        super(sigar);
    }

    public Ulimit ulimit() {
        try {
            return Ulimit.fromSigarBean(this.sigar.getResourceLimit(), this.infinity);
        }
        catch (SigarException e) {
            return Ulimit.undef();
        }
    }

    @Override
    public void registerGauges(MetricRegistry registry) {
        this.registerUlimitOpenFiles(registry);
        this.registerUlimitStackSize(registry);
    }

    public void registerUlimitOpenFiles(MetricRegistry registry) {
        this.registerUlimitOpenFiles(registry, MetricRegistry.name(this.getClass(), (String[])new String[]{"ulimit-open-files"}));
    }

    public void registerUlimitOpenFiles(MetricRegistry registry, String name) {
        registry.register(name, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return UlimitMetrics.this.ulimit().openFiles();
            }
        });
    }

    public void registerUlimitStackSize(MetricRegistry registry) {
        this.registerUlimitStackSize(registry, MetricRegistry.name(this.getClass(), (String[])new String[]{"ulimit-stack-size"}));
    }

    public void registerUlimitStackSize(MetricRegistry registry, String name) {
        registry.register(name, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return UlimitMetrics.this.ulimit().stackSize();
            }
        });
    }

    public static final class Ulimit {
        private final long coreFileSize;
        private final long dataSegSize;
        private final long fileSize;
        private final long pipeSize;
        private final long memSize;
        private final long openFiles;
        private final long stackSize;
        private final long cpuTime;
        private final long processes;
        private final long virtMem;

        private Ulimit(long coreFileSize, long dataSegSize, long fileSize, long pipeSize, long memSize, long openFiles, long stackSize, long cpuTime, long processes, long virtMem) {
            this.coreFileSize = coreFileSize;
            this.dataSegSize = dataSegSize;
            this.fileSize = fileSize;
            this.pipeSize = pipeSize;
            this.memSize = memSize;
            this.openFiles = openFiles;
            this.stackSize = stackSize;
            this.cpuTime = cpuTime;
            this.processes = processes;
            this.virtMem = virtMem;
        }

        public static Ulimit fromSigarBean(ResourceLimit lim, long infinity) {
            return new Ulimit(Ulimit.replaceInfinity(lim.getCoreCur(), infinity), Ulimit.replaceInfinity(lim.getDataCur(), infinity), Ulimit.replaceInfinity(lim.getFileSizeCur(), infinity), Ulimit.replaceInfinity(lim.getPipeSizeCur(), infinity), Ulimit.replaceInfinity(lim.getMemoryCur(), infinity), Ulimit.replaceInfinity(lim.getOpenFilesCur(), infinity), Ulimit.replaceInfinity(lim.getStackCur(), infinity), Ulimit.replaceInfinity(lim.getCpuCur(), infinity), Ulimit.replaceInfinity(lim.getProcessesCur(), infinity), Ulimit.replaceInfinity(lim.getVirtualMemoryCur(), infinity));
        }

        public static Ulimit undef() {
            return new Ulimit(-1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L);
        }

        public long coreFileSize() {
            return this.coreFileSize;
        }

        public long dataSegSize() {
            return this.dataSegSize;
        }

        public long fileSize() {
            return this.fileSize;
        }

        public long pipeSize() {
            return this.pipeSize;
        }

        public long memSize() {
            return this.memSize;
        }

        public long openFiles() {
            return this.openFiles;
        }

        public long stackSize() {
            return this.stackSize;
        }

        public long cpuTime() {
            return this.cpuTime;
        }

        public long processes() {
            return this.processes;
        }

        public long virtMemSize() {
            return this.virtMem;
        }

        private static long replaceInfinity(long value, long infinity) {
            if (value == infinity) {
                return -1L;
            }
            return value;
        }
    }
}

