/*
 * Decompiled with CFR 0.152.
 */
package com.github.cb372.metrics.sigar;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.github.cb372.metrics.sigar.CanRegisterGauges;
import com.github.cb372.metrics.sigar.CpuMetrics;
import com.github.cb372.metrics.sigar.FilesystemMetrics;
import com.github.cb372.metrics.sigar.MemoryMetrics;
import com.github.cb372.metrics.sigar.UlimitMetrics;
import org.hyperic.sigar.Sigar;

public class SigarMetrics
implements CanRegisterGauges {
    private static final SigarMetrics instance = new SigarMetrics();
    private final Sigar sigar = new Sigar();
    private final CpuMetrics cpu = new CpuMetrics(this.sigar);
    private final MemoryMetrics memory = new MemoryMetrics(this.sigar);
    private final FilesystemMetrics fs = new FilesystemMetrics(this.sigar);
    private final UlimitMetrics ulimit = new UlimitMetrics(this.sigar);

    public static SigarMetrics getInstance() {
        return instance;
    }

    private SigarMetrics() {
    }

    @Override
    public void registerGauges(MetricRegistry registry) {
        registry.register(MetricRegistry.name(this.getClass(), (String[])new String[]{"pid"}), (Metric)new Gauge<Long>(){

            public Long getValue() {
                return SigarMetrics.this.pid();
            }
        });
        this.cpu.registerGauges(registry);
        this.memory.registerGauges(registry);
        this.fs.registerGauges(registry);
        this.ulimit.registerGauges(registry);
    }

    public long pid() {
        return this.sigar.getPid();
    }

    public CpuMetrics cpu() {
        return this.cpu;
    }

    public MemoryMetrics memory() {
        return this.memory;
    }

    public FilesystemMetrics filesystems() {
        return this.fs;
    }

    public UlimitMetrics ulimit() {
        return this.ulimit;
    }
}

