/*
 * Decompiled with CFR 0.152.
 */
package com.github.cb372.metrics.sigar;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.github.cb372.metrics.sigar.AbstractSigarMetric;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.Swap;

public class MemoryMetrics
extends AbstractSigarMetric {
    protected MemoryMetrics(Sigar sigar) {
        super(sigar);
    }

    public MainMemory mem() {
        try {
            return MainMemory.fromSigarBean(this.sigar.getMem());
        }
        catch (SigarException e) {
            return MainMemory.undef();
        }
    }

    public SwapSpace swap() {
        try {
            return SwapSpace.fromSigarBean(this.sigar.getSwap());
        }
        catch (SigarException e) {
            return SwapSpace.undef();
        }
    }

    public long ramInMB() {
        try {
            return this.sigar.getMem().getRam();
        }
        catch (SigarException e) {
            return -1L;
        }
    }

    @Override
    public void registerGauges(MetricRegistry registry) {
        this.registerMemoryFree(registry);
        this.registerMemoryActualFree(registry);
        this.registerMemoryUsed(registry);
        this.registerMemoryActualUsed(registry);
        this.registerMemoryTotal(registry);
        this.registerMemoryUsedPercent(registry);
        this.registerMemoryFreePercent(registry);
        this.registerSwapFree(registry);
        this.registerSwapPagesIn(registry);
        this.registerSwapPagesOut(registry);
    }

    public void registerMemoryFree(MetricRegistry registry) {
        this.registerMemoryFree(registry, MetricRegistry.name(this.getClass(), (String[])new String[]{"memory-free"}));
    }

    public void registerMemoryFree(MetricRegistry registry, String name) {
        registry.register(name, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return MemoryMetrics.this.mem().free();
            }
        });
    }

    public void registerMemoryActualFree(MetricRegistry registry) {
        this.registerMemoryActualFree(registry, MetricRegistry.name(this.getClass(), (String[])new String[]{"memory-actual-free"}));
    }

    public void registerMemoryActualFree(MetricRegistry registry, String name) {
        registry.register(name, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return MemoryMetrics.this.mem().actualFree();
            }
        });
    }

    public void registerMemoryUsed(MetricRegistry registry) {
        this.registerMemoryUsed(registry, MetricRegistry.name(this.getClass(), (String[])new String[]{"memory-used"}));
    }

    public void registerMemoryUsed(MetricRegistry registry, String name) {
        registry.register(name, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return MemoryMetrics.this.mem().used();
            }
        });
    }

    public void registerMemoryActualUsed(MetricRegistry registry) {
        this.registerMemoryActualUsed(registry, MetricRegistry.name(this.getClass(), (String[])new String[]{"memory-actual-used"}));
    }

    public void registerMemoryActualUsed(MetricRegistry registry, String name) {
        registry.register(name, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return MemoryMetrics.this.mem().actualUsed();
            }
        });
    }

    public void registerMemoryTotal(MetricRegistry registry) {
        this.registerMemoryTotal(registry, MetricRegistry.name(this.getClass(), (String[])new String[]{"memory-total"}));
    }

    public void registerMemoryTotal(MetricRegistry registry, String name) {
        registry.register(name, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return MemoryMetrics.this.mem().total();
            }
        });
    }

    public void registerMemoryUsedPercent(MetricRegistry registry) {
        this.registerMemoryUsedPercent(registry, MetricRegistry.name(this.getClass(), (String[])new String[]{"memory-used-percent"}));
    }

    public void registerMemoryUsedPercent(MetricRegistry registry, String name) {
        registry.register(name, (Metric)new Gauge<Double>(){

            public Double getValue() {
                return MemoryMetrics.this.mem().usedPercent();
            }
        });
    }

    public void registerMemoryFreePercent(MetricRegistry registry) {
        this.registerMemoryFreePercent(registry, MetricRegistry.name(this.getClass(), (String[])new String[]{"memory-free-percent"}));
    }

    public void registerMemoryFreePercent(MetricRegistry registry, String name) {
        registry.register(name, (Metric)new Gauge<Double>(){

            public Double getValue() {
                return MemoryMetrics.this.mem().freePercent();
            }
        });
    }

    public void registerSwapFree(MetricRegistry registry) {
        this.registerSwapFree(registry, MetricRegistry.name(this.getClass(), (String[])new String[]{"swap-free"}));
    }

    public void registerSwapFree(MetricRegistry registry, String name) {
        registry.register(name, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return MemoryMetrics.this.swap().free();
            }
        });
    }

    public void registerSwapPagesIn(MetricRegistry registry) {
        this.registerSwapPagesIn(registry, MetricRegistry.name(this.getClass(), (String[])new String[]{"swap-pages-in"}));
    }

    public void registerSwapPagesIn(MetricRegistry registry, String name) {
        registry.register(name, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return MemoryMetrics.this.swap().pagesIn();
            }
        });
    }

    public void registerSwapPagesOut(MetricRegistry registry) {
        this.registerSwapPagesOut(registry, MetricRegistry.name(this.getClass(), (String[])new String[]{"swap-pages-out"}));
    }

    public void registerSwapPagesOut(MetricRegistry registry, String name) {
        registry.register(name, (Metric)new Gauge<Long>(){

            public Long getValue() {
                return MemoryMetrics.this.swap().pagesOut();
            }
        });
    }

    public static final class SwapSpace
    extends MemSegment {
        private final long pagesIn;
        private final long pagesOut;

        private SwapSpace(long total, long used, long free, long pagesIn, long pagesOut) {
            super(total, used, free);
            this.pagesIn = pagesIn;
            this.pagesOut = pagesOut;
        }

        public static SwapSpace fromSigarBean(Swap swap) {
            return new SwapSpace(swap.getTotal(), swap.getUsed(), swap.getFree(), swap.getPageIn(), swap.getPageOut());
        }

        private static SwapSpace undef() {
            return new SwapSpace(-1L, -1L, -1L, -1L, -1L);
        }

        public long pagesIn() {
            return this.pagesIn;
        }

        public long pagesOut() {
            return this.pagesOut;
        }
    }

    public static final class MainMemory
    extends MemSegment {
        private final long actualUsed;
        private final long actualFree;
        private final double usedPercent;
        private final double freePercent;

        private MainMemory(long total, long used, long free, long actualUsed, long actualFree, double usedPercent, double freePercent) {
            super(total, used, free);
            this.actualUsed = actualUsed;
            this.actualFree = actualFree;
            this.usedPercent = usedPercent;
            this.freePercent = freePercent;
        }

        public static MainMemory fromSigarBean(Mem mem) {
            return new MainMemory(mem.getTotal(), mem.getUsed(), mem.getFree(), mem.getActualUsed(), mem.getActualFree(), mem.getUsedPercent(), mem.getFreePercent());
        }

        private static MainMemory undef() {
            return new MainMemory(-1L, -1L, -1L, -1L, -1L, -1.0, -1.0);
        }

        public long actualUsed() {
            return this.actualUsed;
        }

        public long actualFree() {
            return this.actualFree;
        }

        public double usedPercent() {
            return this.usedPercent;
        }

        public double freePercent() {
            return this.freePercent;
        }
    }

    public static abstract class MemSegment {
        protected final long total;
        protected final long used;
        protected final long free;

        private MemSegment(long total, long used, long free) {
            this.total = total;
            this.used = used;
            this.free = free;
        }

        public long total() {
            return this.total;
        }

        public long used() {
            return this.used;
        }

        public long free() {
            return this.free;
        }
    }
}

