/*
 * Decompiled with CFR 0.152.
 */
package com.github.cb372.metrics.sigar;

import com.codahale.metrics.MetricRegistry;
import com.github.cb372.metrics.sigar.AbstractSigarMetric;
import java.util.ArrayList;
import java.util.List;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class FilesystemMetrics
extends AbstractSigarMetric {
    @Override
    public void registerGauges(MetricRegistry registry) {
    }

    protected FilesystemMetrics(Sigar sigar) {
        super(sigar);
    }

    public List<FileSystem> filesystems() {
        ArrayList<FileSystem> result = new ArrayList<FileSystem>();
        org.hyperic.sigar.FileSystem[] fss = null;
        try {
            fss = this.sigar.getFileSystemList();
        }
        catch (SigarException e) {
            return result;
        }
        if (fss == null) {
            return result;
        }
        for (org.hyperic.sigar.FileSystem fs : fss) {
            long totalSizeKB = 0L;
            long freeSpaceKB = 0L;
            try {
                FileSystemUsage usage = this.sigar.getFileSystemUsage(fs.getDirName());
                totalSizeKB = usage.getTotal();
                freeSpaceKB = usage.getFree();
            }
            catch (SigarException e) {
                // empty catch block
            }
            result.add(FileSystem.fromSigarBean(fs, totalSizeKB, freeSpaceKB));
        }
        return result;
    }

    public static final class FileSystem {
        private final String deviceName;
        private final String mountPoint;
        private final FSType genericFSType;
        private final String osSpecificFSType;
        private final long totalSizeKB;
        private final long freeSpaceKB;

        public FileSystem(String deviceName, String mountPoint, FSType genericFSType, String osSpecificFSType, long totalSizeKB, long freeSpaceKB) {
            this.deviceName = deviceName;
            this.mountPoint = mountPoint;
            this.genericFSType = genericFSType;
            this.osSpecificFSType = osSpecificFSType;
            this.totalSizeKB = totalSizeKB;
            this.freeSpaceKB = freeSpaceKB;
        }

        public static FileSystem fromSigarBean(org.hyperic.sigar.FileSystem fs, long totalSizeKB, long freeSpaceKB) {
            return new FileSystem(fs.getDevName(), fs.getDirName(), FSType.values()[fs.getType()], fs.getSysTypeName(), totalSizeKB, freeSpaceKB);
        }

        public String deviceName() {
            return this.deviceName;
        }

        public String mountPoint() {
            return this.mountPoint;
        }

        public FSType genericFSType() {
            return this.genericFSType;
        }

        public String osSpecificFSType() {
            return this.osSpecificFSType;
        }

        public long totalSizeKB() {
            return this.totalSizeKB;
        }

        public long freeSpaceKB() {
            return this.freeSpaceKB;
        }
    }

    public static enum FSType {
        Unknown,
        None,
        LocalDisk,
        Network,
        Ramdisk,
        Cdrom,
        Swap;

    }
}

