/*
 * Decompiled with CFR 0.152.
 */
package com.github.cb372.metrics.sigar;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.RatioGauge;
import com.github.cb372.metrics.sigar.AbstractSigarMetric;
import java.util.ArrayList;
import java.util.List;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class CpuMetrics
extends AbstractSigarMetric {
    private static final long HACK_DELAY_MILLIS = 1000L;
    private final CpuInfo info = this.cpuInfo();

    @Override
    public void registerGauges(MetricRegistry registry) {
        this.registerTotalCores(registry);
        this.registerPhysicalCpus(registry);
        this.registerCpuTimeUserPercent(registry);
        this.registerCpuTimeSysPercent(registry);
    }

    public void registerTotalCores(MetricRegistry registry) {
        this.registerTotalCores(registry, MetricRegistry.name(this.getClass(), (String[])new String[]{"total-cores"}));
    }

    public void registerTotalCores(MetricRegistry registry, String name) {
        registry.register(name, (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return CpuMetrics.this.totalCoreCount();
            }
        });
    }

    public void registerPhysicalCpus(MetricRegistry registry) {
        this.registerPhysicalCpus(registry, MetricRegistry.name(this.getClass(), (String[])new String[]{"physical-cpus"}));
    }

    public void registerPhysicalCpus(MetricRegistry registry, String name) {
        registry.register(name, (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                return CpuMetrics.this.physicalCpuCount();
            }
        });
    }

    public void registerCpuTimeUserPercent(MetricRegistry registry) {
        this.registerCpuTimeUserPercent(registry, MetricRegistry.name(this.getClass(), (String[])new String[]{"cpu-time-user-percent"}));
    }

    public void registerCpuTimeUserPercent(MetricRegistry registry, String name) {
        registry.register(name, (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)this.getNumerator(), (double)1.0);
            }

            private double getNumerator() {
                List<CpuTime> cpus = CpuMetrics.this.cpus();
                double userTime = 0.0;
                for (CpuTime cpu : cpus) {
                    userTime += cpu.user();
                }
                return userTime;
            }
        });
    }

    public void registerCpuTimeSysPercent(MetricRegistry registry) {
        this.registerCpuTimeSysPercent(registry, MetricRegistry.name(this.getClass(), (String[])new String[]{"cpu-time-sys-percent"}));
    }

    public void registerCpuTimeSysPercent(MetricRegistry registry, String name) {
        registry.register(name, (Metric)new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)this.getNumerator(), (double)1.0);
            }

            private double getNumerator() {
                List<CpuTime> cpus = CpuMetrics.this.cpus();
                double userTime = 0.0;
                for (CpuTime cpu : cpus) {
                    userTime += cpu.sys();
                }
                return userTime;
            }
        });
    }

    protected CpuMetrics(Sigar sigar) {
        super(sigar);
    }

    public int totalCoreCount() {
        if (this.info == null) {
            return -1;
        }
        return this.info.getTotalCores();
    }

    public int physicalCpuCount() {
        if (this.info == null) {
            return -1;
        }
        return this.info.getTotalSockets();
    }

    public List<CpuTime> cpus() {
        ArrayList<CpuTime> result = new ArrayList<CpuTime>();
        CpuPerc[] cpus = this.cpuPercList();
        if (cpus == null) {
            return result;
        }
        if (Double.isNaN(cpus[0].getIdle())) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return result;
            }
            cpus = this.cpuPercList();
            if (cpus == null) {
                return result;
            }
        }
        for (CpuPerc cp : cpus) {
            result.add(CpuTime.fromSigarBean(cp));
        }
        return result;
    }

    private CpuInfo cpuInfo() {
        try {
            CpuInfo[] infos = this.sigar.getCpuInfoList();
            if (infos == null || infos.length == 0) {
                return null;
            }
            return infos[0];
        }
        catch (SigarException e) {
            return null;
        }
    }

    private CpuPerc[] cpuPercList() {
        CpuPerc[] cpus = null;
        try {
            cpus = this.sigar.getCpuPercList();
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
        if (cpus == null || cpus.length == 0) {
            return null;
        }
        return cpus;
    }

    public static final class CpuTime {
        private final double user;
        private final double sys;
        private final double nice;
        private final double waiting;
        private final double idle;
        private final double irq;

        public CpuTime(double user, double sys, double nice, double waiting, double idle, double irq) {
            this.user = user;
            this.sys = sys;
            this.nice = nice;
            this.waiting = waiting;
            this.idle = idle;
            this.irq = irq;
        }

        public static CpuTime fromSigarBean(CpuPerc cp) {
            return new CpuTime(cp.getUser(), cp.getSys(), cp.getNice(), cp.getWait(), cp.getIdle(), cp.getIrq());
        }

        public double user() {
            return this.user;
        }

        public double sys() {
            return this.sys;
        }

        public double nice() {
            return this.nice;
        }

        public double waiting() {
            return this.waiting;
        }

        public double idle() {
            return this.idle;
        }

        public double irq() {
            return this.irq;
        }
    }
}

