/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.payscore.PayScoreNotifyData;
import com.github.binarywang.wxpay.bean.payscore.WxPayScoreRequest;
import com.github.binarywang.wxpay.bean.payscore.WxPayScoreResult;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.PayScoreService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.v3.util.AesUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;

public class PayScoreServiceImpl
implements PayScoreService {
    private final WxPayService payService;

    @Override
    public WxPayScoreResult createServiceOrder(WxPayScoreRequest request) throws WxPayException {
        boolean needUserConfirm = request.isNeedUserConfirm();
        WxPayConfig config = this.payService.getConfig();
        String url = this.payService.getPayBaseUrl() + "/v3/payscore/serviceorder";
        request.setAppid(config.getAppId());
        request.setServiceId(config.getServiceId());
        request.setNotifyUrl(config.getPayScoreNotifyUrl());
        String result = this.payService.postV3(url, request.toJson());
        WxPayScoreResult wxPayScoreCreateResult = WxPayScoreResult.fromJson(result);
        String currentTimeMillis = System.currentTimeMillis() + "";
        HashMap<String, String> signMap = new HashMap<String, String>(8);
        signMap.put("mch_id", config.getMchId());
        if (needUserConfirm) {
            signMap.put("package", wxPayScoreCreateResult.getPackageX());
        } else {
            signMap.put("service_id", config.getServiceId());
            signMap.put("out_order_no", request.getOutOrderNo());
        }
        signMap.put("timestamp", currentTimeMillis);
        signMap.put("nonce_str", currentTimeMillis);
        signMap.put("sign_type", "HMAC-SHA256");
        String sign = AesUtils.createSign(signMap, config.getMchKey());
        signMap.put("sign", sign);
        wxPayScoreCreateResult.setPayScoreSignInfo(signMap);
        return wxPayScoreCreateResult;
    }

    @Override
    public WxPayScoreResult queryServiceOrder(String outOrderNo, String queryId) throws WxPayException {
        URIBuilder uriBuilder;
        WxPayConfig config = this.payService.getConfig();
        String url = this.payService.getPayBaseUrl() + "/v3/payscore/serviceorder";
        try {
            uriBuilder = new URIBuilder(url);
        }
        catch (URISyntaxException e) {
            throw new WxPayException("\u672a\u77e5\u5f02\u5e38\uff01", e);
        }
        if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{outOrderNo, queryId}) || !StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{outOrderNo, queryId})) {
            throw new WxPayException("out_order_no,query_id\u4e0d\u5141\u8bb8\u90fd\u586b\u5199\u6216\u90fd\u4e0d\u586b\u5199");
        }
        if (StringUtils.isNotEmpty((CharSequence)outOrderNo)) {
            uriBuilder.setParameter("out_order_no", outOrderNo);
        }
        if (StringUtils.isNotEmpty((CharSequence)queryId)) {
            uriBuilder.setParameter("query_id", queryId);
        }
        uriBuilder.setParameter("service_id", config.getServiceId());
        uriBuilder.setParameter("appid", config.getAppId());
        try {
            String result = this.payService.getV3(uriBuilder.build());
            return WxPayScoreResult.fromJson(result);
        }
        catch (URISyntaxException e) {
            throw new WxPayException("\u672a\u77e5\u5f02\u5e38\uff01", e);
        }
    }

    @Override
    public WxPayScoreResult cancelServiceOrder(String outOrderNo, String reason) throws WxPayException {
        WxPayConfig config = this.payService.getConfig();
        String url = String.format("%s/v3/payscore/serviceorder/%s/cancel", this.payService.getPayBaseUrl(), outOrderNo);
        HashMap<String, String> map = new HashMap<String, String>(4);
        map.put("appid", config.getAppId());
        map.put("service_id", config.getServiceId());
        map.put("reason", reason);
        String result = this.payService.postV3(url, WxGsonBuilder.create().toJson(map));
        return WxPayScoreResult.fromJson(result);
    }

    @Override
    public WxPayScoreResult modifyServiceOrder(WxPayScoreRequest request) throws WxPayException {
        WxPayConfig config = this.payService.getConfig();
        String outOrderNo = request.getOutOrderNo();
        String url = String.format("%s/v3/payscore/serviceorder/%s/modify", this.payService.getPayBaseUrl(), outOrderNo);
        request.setAppid(config.getAppId());
        request.setServiceId(config.getServiceId());
        request.setOutOrderNo(null);
        String result = this.payService.postV3(url, request.toJson());
        return WxPayScoreResult.fromJson(result);
    }

    @Override
    public WxPayScoreResult completeServiceOrder(WxPayScoreRequest request) throws WxPayException {
        WxPayConfig config = this.payService.getConfig();
        String outOrderNo = request.getOutOrderNo();
        String url = String.format("%s/v3/payscore/serviceorder/%s/complete", this.payService.getPayBaseUrl(), outOrderNo);
        request.setAppid(config.getAppId());
        request.setServiceId(config.getServiceId());
        request.setOutOrderNo(null);
        String result = this.payService.postV3(url, request.toJson());
        return WxPayScoreResult.fromJson(result);
    }

    @Override
    public WxPayScoreResult payServiceOrder(String outOrderNo) throws WxPayException {
        WxPayConfig config = this.payService.getConfig();
        String url = String.format("%s/v3/payscore/serviceorder/%s/pay", this.payService.getPayBaseUrl(), outOrderNo);
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put("appid", config.getAppId());
        map.put("service_id", config.getServiceId());
        String result = this.payService.postV3(url, WxGsonBuilder.create().toJson(map));
        return WxPayScoreResult.fromJson(result);
    }

    @Override
    public WxPayScoreResult syncServiceOrder(WxPayScoreRequest request) throws WxPayException {
        WxPayConfig config = this.payService.getConfig();
        String outOrderNo = request.getOutOrderNo();
        String url = String.format("%s/v3/payscore/serviceorder/%s/sync", this.payService.getPayBaseUrl(), outOrderNo);
        request.setAppid(config.getAppId());
        request.setServiceId(config.getServiceId());
        request.setOutOrderNo(null);
        String result = this.payService.postV3(url, request.toJson());
        return WxPayScoreResult.fromJson(result);
    }

    @Override
    public PayScoreNotifyData parseNotifyData(String data) {
        return (PayScoreNotifyData)WxGsonBuilder.create().fromJson(data, PayScoreNotifyData.class);
    }

    @Override
    public WxPayScoreResult decryptNotifyDataResource(PayScoreNotifyData data) throws WxPayException {
        PayScoreNotifyData.Resource resource = data.getResource();
        String cipherText = resource.getCipherText();
        String associatedData = resource.getAssociatedData();
        String nonce = resource.getNonce();
        String apiV3Key = this.payService.getConfig().getApiV3Key();
        try {
            return WxPayScoreResult.fromJson(AesUtils.decryptToString(associatedData, nonce, cipherText, apiV3Key));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new WxPayException("\u89e3\u6790\u62a5\u6587\u5f02\u5e38\uff01", e);
        }
    }

    public PayScoreServiceImpl(WxPayService payService) {
        this.payService = payService;
    }
}

