/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.bean.result;

import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.bean.result.WxPayRefundCouponInfo;
import com.google.common.collect.Lists;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

@XStreamAlias(value="xml")
public class WxPayRefundResult
extends BaseWxPayResult
implements Serializable {
    private static final long serialVersionUID = -3392333879907788033L;
    @XStreamAlias(value="transaction_id")
    private String transactionId;
    @XStreamAlias(value="out_trade_no")
    private String outTradeNo;
    @XStreamAlias(value="out_refund_no")
    private String outRefundNo;
    @XStreamAlias(value="refund_id")
    private String refundId;
    @XStreamAlias(value="refund_fee")
    private Integer refundFee;
    @XStreamAlias(value="settlement_refund_fee")
    private Integer settlementRefundFee;
    @XStreamAlias(value="total_fee")
    private Integer totalFee;
    @XStreamAlias(value="settlement_total_fee")
    private Integer settlementTotalFee;
    @XStreamAlias(value="fee_type")
    private String feeType;
    @XStreamAlias(value="cash_fee")
    private Integer cashFee;
    @XStreamAlias(value="cash_fee_type")
    private String cashFeeType;
    @XStreamAlias(value="cash_refund_fee")
    private Integer cashRefundFee;
    @XStreamAlias(value="coupon_refund_count")
    private Integer couponRefundCount;
    @XStreamAlias(value="coupon_refund_fee")
    private Integer couponRefundFee;
    private List<WxPayRefundCouponInfo> refundCoupons;

    private void composeRefundCoupons() {
        ArrayList coupons = Lists.newArrayList();
        Integer refundCount = this.getCouponRefundCount();
        if (refundCount == null) {
            return;
        }
        for (int i = 0; i < refundCount; ++i) {
            coupons.add(new WxPayRefundCouponInfo(this.getXmlValue("xml/coupon_refund_id_" + i), this.getXmlValueAsInt("xml/coupon_refund_fee_" + i), this.getXmlValue("xml/coupon_type_" + i)));
        }
        this.setRefundCoupons(coupons);
    }

    public static WxPayRefundResult fromXML(String xml) {
        WxPayRefundResult result = BaseWxPayResult.fromXML(xml, WxPayRefundResult.class);
        result.composeRefundCoupons();
        return result;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public String getOutTradeNo() {
        return this.outTradeNo;
    }

    public String getOutRefundNo() {
        return this.outRefundNo;
    }

    public String getRefundId() {
        return this.refundId;
    }

    public Integer getRefundFee() {
        return this.refundFee;
    }

    public Integer getSettlementRefundFee() {
        return this.settlementRefundFee;
    }

    public Integer getTotalFee() {
        return this.totalFee;
    }

    public Integer getSettlementTotalFee() {
        return this.settlementTotalFee;
    }

    public String getFeeType() {
        return this.feeType;
    }

    public Integer getCashFee() {
        return this.cashFee;
    }

    public String getCashFeeType() {
        return this.cashFeeType;
    }

    public Integer getCashRefundFee() {
        return this.cashRefundFee;
    }

    public Integer getCouponRefundCount() {
        return this.couponRefundCount;
    }

    public Integer getCouponRefundFee() {
        return this.couponRefundFee;
    }

    public List<WxPayRefundCouponInfo> getRefundCoupons() {
        return this.refundCoupons;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public void setOutRefundNo(String outRefundNo) {
        this.outRefundNo = outRefundNo;
    }

    public void setRefundId(String refundId) {
        this.refundId = refundId;
    }

    public void setRefundFee(Integer refundFee) {
        this.refundFee = refundFee;
    }

    public void setSettlementRefundFee(Integer settlementRefundFee) {
        this.settlementRefundFee = settlementRefundFee;
    }

    public void setTotalFee(Integer totalFee) {
        this.totalFee = totalFee;
    }

    public void setSettlementTotalFee(Integer settlementTotalFee) {
        this.settlementTotalFee = settlementTotalFee;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public void setCashFee(Integer cashFee) {
        this.cashFee = cashFee;
    }

    public void setCashFeeType(String cashFeeType) {
        this.cashFeeType = cashFeeType;
    }

    public void setCashRefundFee(Integer cashRefundFee) {
        this.cashRefundFee = cashRefundFee;
    }

    public void setCouponRefundCount(Integer couponRefundCount) {
        this.couponRefundCount = couponRefundCount;
    }

    public void setCouponRefundFee(Integer couponRefundFee) {
        this.couponRefundFee = couponRefundFee;
    }

    public void setRefundCoupons(List<WxPayRefundCouponInfo> refundCoupons) {
        this.refundCoupons = refundCoupons;
    }

    @Override
    public String toString() {
        return "WxPayRefundResult(transactionId=" + this.getTransactionId() + ", outTradeNo=" + this.getOutTradeNo() + ", outRefundNo=" + this.getOutRefundNo() + ", refundId=" + this.getRefundId() + ", refundFee=" + this.getRefundFee() + ", settlementRefundFee=" + this.getSettlementRefundFee() + ", totalFee=" + this.getTotalFee() + ", settlementTotalFee=" + this.getSettlementTotalFee() + ", feeType=" + this.getFeeType() + ", cashFee=" + this.getCashFee() + ", cashFeeType=" + this.getCashFeeType() + ", cashRefundFee=" + this.getCashRefundFee() + ", couponRefundCount=" + this.getCouponRefundCount() + ", couponRefundFee=" + this.getCouponRefundFee() + ", refundCoupons=" + this.getRefundCoupons() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxPayRefundResult)) {
            return false;
        }
        WxPayRefundResult other = (WxPayRefundResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$transactionId = this.getTransactionId();
        String other$transactionId = other.getTransactionId();
        if (this$transactionId == null ? other$transactionId != null : !this$transactionId.equals(other$transactionId)) {
            return false;
        }
        String this$outTradeNo = this.getOutTradeNo();
        String other$outTradeNo = other.getOutTradeNo();
        if (this$outTradeNo == null ? other$outTradeNo != null : !this$outTradeNo.equals(other$outTradeNo)) {
            return false;
        }
        String this$outRefundNo = this.getOutRefundNo();
        String other$outRefundNo = other.getOutRefundNo();
        if (this$outRefundNo == null ? other$outRefundNo != null : !this$outRefundNo.equals(other$outRefundNo)) {
            return false;
        }
        String this$refundId = this.getRefundId();
        String other$refundId = other.getRefundId();
        if (this$refundId == null ? other$refundId != null : !this$refundId.equals(other$refundId)) {
            return false;
        }
        Integer this$refundFee = this.getRefundFee();
        Integer other$refundFee = other.getRefundFee();
        if (this$refundFee == null ? other$refundFee != null : !((Object)this$refundFee).equals(other$refundFee)) {
            return false;
        }
        Integer this$settlementRefundFee = this.getSettlementRefundFee();
        Integer other$settlementRefundFee = other.getSettlementRefundFee();
        if (this$settlementRefundFee == null ? other$settlementRefundFee != null : !((Object)this$settlementRefundFee).equals(other$settlementRefundFee)) {
            return false;
        }
        Integer this$totalFee = this.getTotalFee();
        Integer other$totalFee = other.getTotalFee();
        if (this$totalFee == null ? other$totalFee != null : !((Object)this$totalFee).equals(other$totalFee)) {
            return false;
        }
        Integer this$settlementTotalFee = this.getSettlementTotalFee();
        Integer other$settlementTotalFee = other.getSettlementTotalFee();
        if (this$settlementTotalFee == null ? other$settlementTotalFee != null : !((Object)this$settlementTotalFee).equals(other$settlementTotalFee)) {
            return false;
        }
        String this$feeType = this.getFeeType();
        String other$feeType = other.getFeeType();
        if (this$feeType == null ? other$feeType != null : !this$feeType.equals(other$feeType)) {
            return false;
        }
        Integer this$cashFee = this.getCashFee();
        Integer other$cashFee = other.getCashFee();
        if (this$cashFee == null ? other$cashFee != null : !((Object)this$cashFee).equals(other$cashFee)) {
            return false;
        }
        String this$cashFeeType = this.getCashFeeType();
        String other$cashFeeType = other.getCashFeeType();
        if (this$cashFeeType == null ? other$cashFeeType != null : !this$cashFeeType.equals(other$cashFeeType)) {
            return false;
        }
        Integer this$cashRefundFee = this.getCashRefundFee();
        Integer other$cashRefundFee = other.getCashRefundFee();
        if (this$cashRefundFee == null ? other$cashRefundFee != null : !((Object)this$cashRefundFee).equals(other$cashRefundFee)) {
            return false;
        }
        Integer this$couponRefundCount = this.getCouponRefundCount();
        Integer other$couponRefundCount = other.getCouponRefundCount();
        if (this$couponRefundCount == null ? other$couponRefundCount != null : !((Object)this$couponRefundCount).equals(other$couponRefundCount)) {
            return false;
        }
        Integer this$couponRefundFee = this.getCouponRefundFee();
        Integer other$couponRefundFee = other.getCouponRefundFee();
        if (this$couponRefundFee == null ? other$couponRefundFee != null : !((Object)this$couponRefundFee).equals(other$couponRefundFee)) {
            return false;
        }
        List<WxPayRefundCouponInfo> this$refundCoupons = this.getRefundCoupons();
        List<WxPayRefundCouponInfo> other$refundCoupons = other.getRefundCoupons();
        return !(this$refundCoupons == null ? other$refundCoupons != null : !((Object)this$refundCoupons).equals(other$refundCoupons));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WxPayRefundResult;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $transactionId = this.getTransactionId();
        result = result * 59 + ($transactionId == null ? 43 : $transactionId.hashCode());
        String $outTradeNo = this.getOutTradeNo();
        result = result * 59 + ($outTradeNo == null ? 43 : $outTradeNo.hashCode());
        String $outRefundNo = this.getOutRefundNo();
        result = result * 59 + ($outRefundNo == null ? 43 : $outRefundNo.hashCode());
        String $refundId = this.getRefundId();
        result = result * 59 + ($refundId == null ? 43 : $refundId.hashCode());
        Integer $refundFee = this.getRefundFee();
        result = result * 59 + ($refundFee == null ? 43 : ((Object)$refundFee).hashCode());
        Integer $settlementRefundFee = this.getSettlementRefundFee();
        result = result * 59 + ($settlementRefundFee == null ? 43 : ((Object)$settlementRefundFee).hashCode());
        Integer $totalFee = this.getTotalFee();
        result = result * 59 + ($totalFee == null ? 43 : ((Object)$totalFee).hashCode());
        Integer $settlementTotalFee = this.getSettlementTotalFee();
        result = result * 59 + ($settlementTotalFee == null ? 43 : ((Object)$settlementTotalFee).hashCode());
        String $feeType = this.getFeeType();
        result = result * 59 + ($feeType == null ? 43 : $feeType.hashCode());
        Integer $cashFee = this.getCashFee();
        result = result * 59 + ($cashFee == null ? 43 : ((Object)$cashFee).hashCode());
        String $cashFeeType = this.getCashFeeType();
        result = result * 59 + ($cashFeeType == null ? 43 : $cashFeeType.hashCode());
        Integer $cashRefundFee = this.getCashRefundFee();
        result = result * 59 + ($cashRefundFee == null ? 43 : ((Object)$cashRefundFee).hashCode());
        Integer $couponRefundCount = this.getCouponRefundCount();
        result = result * 59 + ($couponRefundCount == null ? 43 : ((Object)$couponRefundCount).hashCode());
        Integer $couponRefundFee = this.getCouponRefundFee();
        result = result * 59 + ($couponRefundFee == null ? 43 : ((Object)$couponRefundFee).hashCode());
        List<WxPayRefundCouponInfo> $refundCoupons = this.getRefundCoupons();
        result = result * 59 + ($refundCoupons == null ? 43 : ((Object)$refundCoupons).hashCode());
        return result;
    }
}

