/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import me.chanjar.weixin.open.api.impl.WxOpenInMemoryConfigStorage;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.util.Pool;

public class WxOpenInRedisConfigStorage
extends WxOpenInMemoryConfigStorage {
    private static final String COMPONENT_VERIFY_TICKET_KEY = "wechat_component_verify_ticket:";
    private static final String COMPONENT_ACCESS_TOKEN_KEY = "wechat_component_access_token:";
    private static final String AUTHORIZER_REFRESH_TOKEN_KEY = "wechat_authorizer_refresh_token:";
    private static final String AUTHORIZER_ACCESS_TOKEN_KEY = "wechat_authorizer_access_token:";
    private static final String JSAPI_TICKET_KEY = "wechat_jsapi_ticket:";
    private static final String CARD_API_TICKET_KEY = "wechat_card_api_ticket:";
    protected final Pool<Jedis> jedisPool;
    private String keyPrefix;
    private String componentVerifyTicketKey;
    private String componentAccessTokenKey;
    private String authorizerRefreshTokenKey;
    private String authorizerAccessTokenKey;
    private String jsapiTicketKey;
    private String cardApiTicket;

    public WxOpenInRedisConfigStorage(Pool<Jedis> jedisPool) {
        this.jedisPool = jedisPool;
    }

    public WxOpenInRedisConfigStorage(Pool<Jedis> jedisPool, String keyPrefix) {
        this.jedisPool = jedisPool;
        this.keyPrefix = keyPrefix;
    }

    public WxOpenInRedisConfigStorage(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public void setComponentAppId(String componentAppId) {
        super.setComponentAppId(componentAppId);
        String prefix = StringUtils.isBlank((CharSequence)this.keyPrefix) ? "" : (StringUtils.endsWith((CharSequence)this.keyPrefix, (CharSequence)":") ? this.keyPrefix : this.keyPrefix + ":");
        this.componentVerifyTicketKey = prefix + COMPONENT_VERIFY_TICKET_KEY.concat(componentAppId);
        this.componentAccessTokenKey = prefix + COMPONENT_ACCESS_TOKEN_KEY.concat(componentAppId);
        this.authorizerRefreshTokenKey = prefix + AUTHORIZER_REFRESH_TOKEN_KEY.concat(componentAppId);
        this.authorizerAccessTokenKey = prefix + AUTHORIZER_ACCESS_TOKEN_KEY.concat(componentAppId);
        this.jsapiTicketKey = JSAPI_TICKET_KEY.concat(componentAppId);
        this.cardApiTicket = CARD_API_TICKET_KEY.concat(componentAppId);
    }

    @Override
    public String getComponentVerifyTicket() {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.get(this.componentVerifyTicketKey);
            return string;
        }
    }

    @Override
    public void setComponentVerifyTicket(String componentVerifyTicket) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            jedis.set(this.componentVerifyTicketKey, componentVerifyTicket);
        }
    }

    @Override
    public String getComponentAccessToken() {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.get(this.componentAccessTokenKey);
            return string;
        }
    }

    @Override
    public boolean isComponentAccessTokenExpired() {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            boolean bl = jedis.ttl(this.componentAccessTokenKey) < 2L;
            return bl;
        }
    }

    @Override
    public void expireComponentAccessToken() {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            jedis.expire(this.componentAccessTokenKey, 0);
        }
    }

    @Override
    public void updateComponentAccessToken(String componentAccessToken, int expiresInSeconds) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            jedis.setex(this.componentAccessTokenKey, expiresInSeconds - 200, componentAccessToken);
        }
    }

    private String getKey(String prefix, String appId) {
        return prefix.endsWith(":") ? prefix.concat(appId) : prefix.concat(":").concat(appId);
    }

    @Override
    public String getAuthorizerRefreshToken(String appId) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.get(this.getKey(this.authorizerRefreshTokenKey, appId));
            return string;
        }
    }

    @Override
    public void setAuthorizerRefreshToken(String appId, String authorizerRefreshToken) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            jedis.set(this.getKey(this.authorizerRefreshTokenKey, appId), authorizerRefreshToken);
        }
    }

    @Override
    public String getAuthorizerAccessToken(String appId) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.get(this.getKey(this.authorizerAccessTokenKey, appId));
            return string;
        }
    }

    @Override
    public boolean isAuthorizerAccessTokenExpired(String appId) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            boolean bl = jedis.ttl(this.getKey(this.authorizerAccessTokenKey, appId)) < 2L;
            return bl;
        }
    }

    @Override
    public void expireAuthorizerAccessToken(String appId) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            jedis.expire(this.getKey(this.authorizerAccessTokenKey, appId), 0);
        }
    }

    @Override
    public void updateAuthorizerAccessToken(String appId, String authorizerAccessToken, int expiresInSeconds) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            jedis.setex(this.getKey(this.authorizerAccessTokenKey, appId), expiresInSeconds - 200, authorizerAccessToken);
        }
    }

    @Override
    public String getJsapiTicket(String appId) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.get(this.getKey(this.jsapiTicketKey, appId));
            return string;
        }
    }

    @Override
    public boolean isJsapiTicketExpired(String appId) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            boolean bl = jedis.ttl(this.getKey(this.jsapiTicketKey, appId)) < 2L;
            return bl;
        }
    }

    @Override
    public void expireJsapiTicket(String appId) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            jedis.expire(this.getKey(this.jsapiTicketKey, appId), 0);
        }
    }

    @Override
    public void updateJsapiTicket(String appId, String jsapiTicket, int expiresInSeconds) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            jedis.setex(this.getKey(this.jsapiTicketKey, appId), expiresInSeconds - 200, jsapiTicket);
        }
    }

    @Override
    public String getCardApiTicket(String appId) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            String string = jedis.get(this.getKey(this.cardApiTicket, appId));
            return string;
        }
    }

    @Override
    public boolean isCardApiTicketExpired(String appId) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            boolean bl = jedis.ttl(this.getKey(this.cardApiTicket, appId)) < 2L;
            return bl;
        }
    }

    @Override
    public void expireCardApiTicket(String appId) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            jedis.expire(this.getKey(this.cardApiTicket, appId), 0);
        }
    }

    @Override
    public void updateCardApiTicket(String appId, String cardApiTicket, int expiresInSeconds) {
        try (Jedis jedis = (Jedis)this.jedisPool.getResource();){
            jedis.setex(this.getKey(this.cardApiTicket, appId), expiresInSeconds - 200, cardApiTicket);
        }
    }
}

