/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import java.util.LinkedHashMap;
import java.util.List;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import me.chanjar.weixin.mp.api.WxMpGuideMassedJobService;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.bean.guide.WxMpGuideMassed;
import me.chanjar.weixin.mp.bean.guide.WxMpGuideMassedInfo;
import me.chanjar.weixin.mp.bean.guide.WxMpGuideMaterialInfo;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;

public class WxMpGuideMassedJobServiceImpl
implements WxMpGuideMassedJobService {
    private static final String ACCOUNT = "guide_account";
    private static final String OPENID = "guide_openid";
    private final WxMpService mpService;

    @Override
    public WxMpGuideMassed addGuideMassedJob(String account, String openid, String taskName, String taskRemark, Long pushTime, List<String> userOpenIds, List<WxMpGuideMaterialInfo> materialInfos) throws WxErrorException {
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        body.put(ACCOUNT, account);
        body.put(OPENID, openid);
        body.put("task_name", taskName);
        body.put("task_remark", taskRemark);
        body.put("push_time", pushTime);
        body.put("openid", userOpenIds);
        body.put("material", materialInfos);
        String returnString = this.mpService.post((WxMpApiUrl)WxMpApiUrl.Guide.ADD_GUIDE_MASSED_JOB, body);
        return WxMpGuideMassed.fromJson(GsonParser.parse((String)returnString).getAsJsonArray("task_result").get(0));
    }

    @Override
    public List<WxMpGuideMassedInfo> getGuideMassedJobList(String account, String openid, List<Integer> taskStatus, Integer offset, Integer limit) throws WxErrorException {
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        body.put(ACCOUNT, account);
        body.put(OPENID, openid);
        body.put("task_status", taskStatus);
        body.put("offset", offset);
        body.put("limit", limit);
        String returnString = this.mpService.post((WxMpApiUrl)WxMpApiUrl.Guide.GET_GUIDE_MASSED_JOB_LIST, body);
        return (List)WxGsonBuilder.create().fromJson((JsonElement)GsonParser.parse((String)returnString).getAsJsonArray("list"), new TypeToken<List<WxMpGuideMassedInfo>>(){}.getType());
    }

    @Override
    public WxMpGuideMassedInfo getGuideMassedJob(String taskId) throws WxErrorException {
        String returnString = this.mpService.post((WxMpApiUrl)WxMpApiUrl.Guide.GET_GUIDE_MASSED_JOB, GsonHelper.buildJsonObject((Object[])new Object[]{"task_id", taskId}));
        return WxMpGuideMassedInfo.fromJson(GsonParser.parse((String)returnString).get("job"));
    }

    @Override
    public void updateGuideMassedJob(String taskId, String taskName, String taskRemark, Long pushTime, List<String> userOpenIds, List<WxMpGuideMaterialInfo> materialInfos) throws WxErrorException {
        LinkedHashMap<String, Object> body = new LinkedHashMap<String, Object>();
        body.put("task_id", taskId);
        body.put("task_name", taskName);
        body.put("task_remark", taskRemark);
        body.put("push_time", pushTime);
        body.put("openid", userOpenIds);
        body.put("material", materialInfos);
        this.mpService.post((WxMpApiUrl)WxMpApiUrl.Guide.UPDATE_GUIDE_MASSED_JOB, body);
    }

    @Override
    public void cancelGuideMassedJob(String taskId) throws WxErrorException {
        this.mpService.post((WxMpApiUrl)WxMpApiUrl.Guide.CANCEL_GUIDE_MASSED_JOB, GsonHelper.buildJsonObject((Object[])new Object[]{"task_id", taskId}));
    }

    public WxMpGuideMassedJobServiceImpl(WxMpService mpService) {
        this.mpService = mpService;
    }
}

