/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.dom4j.tree.DefaultText;
import org.xml.sax.SAXException;

public class XmlUtils {
    public static Map<String, Object> xml2Map(String xmlString) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        try {
            SAXReader saxReader = new SAXReader();
            saxReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            saxReader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            saxReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            Document doc = saxReader.read((Reader)new StringReader(xmlString));
            Element root = doc.getRootElement();
            List elements = root.elements();
            for (Element element : elements) {
                map.put(element.getName(), XmlUtils.element2MapOrString(element));
            }
        }
        catch (DocumentException | SAXException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    private static Object element2MapOrString(Element element) {
        HashMap result = Maps.newHashMap();
        List content = element.content();
        if (content.size() <= 1) {
            return element.getText();
        }
        Set<String> names = XmlUtils.names(content);
        if (names.size() == 1) {
            ArrayList list = Lists.newArrayList();
            for (Node node : content) {
                if (node instanceof DefaultText || !(node instanceof Element)) continue;
                list.add(XmlUtils.element2MapOrString((Element)node));
            }
            result.put(names.iterator().next(), list);
        } else {
            for (Node node : content) {
                if (node instanceof DefaultText || !(node instanceof Element)) continue;
                result.put(node.getName(), XmlUtils.element2MapOrString((Element)node));
            }
        }
        return result;
    }

    private static Set<String> names(List<Node> nodes) {
        HashSet names = Sets.newHashSet();
        for (Node node : nodes) {
            if (node instanceof DefaultText) continue;
            names.add(node.getName());
        }
        return names;
    }
}

