/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UrlMatcher {
    private static Log log = LogFactory.getLog(UrlMatcher.class);

    public static String replaceParams(String regex, String name, String value) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(name, value);
        return UrlMatcher.replaceParams(regex, map);
    }

    public static String replaceParams(String srcUrl, Map<String, String> params) {
        return UrlMatcher.replaceRegexs(srcUrl, "\\{(.*?)\\}", params);
    }

    public static String replaceFields(String regex, String name, String value) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(name, value);
        return UrlMatcher.replaceFields(regex, map);
    }

    public static String replaceFields(String srcUrl, Map<String, String> params) {
        return UrlMatcher.replaceRegexs(srcUrl, "\\[(.*?)\\]", params);
    }

    public static String replaceRegexs(String srcUrl, String regex, Map<String, String> params) {
        if (params == null) {
            return srcUrl;
        }
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(srcUrl);
        while (matcher.find()) {
            String name = matcher.group(1);
            String value = params.get(name);
            if (!StringUtils.isNotEmpty((CharSequence)value)) continue;
            matcher.appendReplacement(sb, value);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static Map<String, String> match(String url, String regex) {
        String regexSrc = StringUtils.replace((String)regex, (String)"?", (String)"\\?");
        String regex1 = "\\{(.*?)\\}";
        StringBuffer sb = new StringBuffer();
        Pattern pattern = Pattern.compile(regex1);
        Matcher matcher = pattern.matcher(regexSrc);
        ArrayList<String> names = new ArrayList<String>();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "([^/]*)");
            String name = matcher.group(1);
            names.add(name);
        }
        if (names.size() > 0) {
            Pattern pattern2;
            Matcher matcher2;
            matcher.appendTail(sb);
            String regex2 = sb.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)regex2);
            }
            if ((matcher2 = (pattern2 = Pattern.compile(regex2 = "^" + regex2)).matcher(url)).matches()) {
                HashMap<String, String> params = new HashMap<String, String>(names.size());
                int i = 1;
                while (i <= matcher2.groupCount()) {
                    String value = matcher2.group(i);
                    try {
                        value = URLDecoder.decode(value, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    params.put((String)names.get(i - 1), value);
                    ++i;
                }
                return params;
            }
        } else if (url.equals(regex)) {
            return new HashMap<String, String>(0);
        }
        return null;
    }

    public static void main(String[] args) {
        String url = "http://www.ly.com/HotelInfo-597101.html#id_nameAndSliderInfo&is=1&searchId=undefined&ab=0";
        String regex = "http://www.ly.com/HotelInfo-{code}.html#{hash}";
        System.out.println(UrlMatcher.match(url, regex));
    }
}

