/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.utils;

import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadImage {
    private static Log log = LogFactory.getLog(DownloadImage.class);

    public static String download(String parentPath, String imgUrl) {
        if (Strings.isNullOrEmpty((String)imgUrl) || Strings.isNullOrEmpty((String)parentPath)) {
            return null;
        }
        if (imgUrl.length() > 500) {
            return null;
        }
        Closer closer = Closer.create();
        try {
            File imageDir = new File(parentPath);
            if (!imageDir.exists()) {
                imageDir.mkdirs();
            }
            String fileName = StringUtils.substringBefore((String)imgUrl, (String)"?");
            fileName = StringUtils.substringAfterLast((String)fileName, (String)"/");
            File imageFile = new File(imageDir, fileName);
            InputStream in = (InputStream)closer.register((Closeable)new URL(imgUrl).openStream());
            Files.write((byte[])ByteStreams.toByteArray((InputStream)in), (File)imageFile);
            String string = imageFile.getAbsolutePath();
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            log.error((Object)("image download error :" + imgUrl));
            return null;
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException e) {
                closer = null;
            }
        }
    }

    public static String download(String parentPath, String fileName, InputStream in) {
        Closer closer = Closer.create();
        try {
            File imageDir = new File(parentPath);
            if (!imageDir.exists()) {
                imageDir.mkdirs();
            }
            File imageFile = new File(imageDir, fileName);
            Files.write((byte[])ByteStreams.toByteArray((InputStream)in), (File)imageFile);
            String string = imageFile.getAbsolutePath();
            return string;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException e) {
                closer = null;
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(DownloadImage.download("d:\\", "http://git.oschina.net/uploads/78/666978_xtuhcy.jpg?1459474621"));
    }
}

