/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.spider.render.json;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONPath;
import com.geccocrawler.gecco.request.HttpRequest;
import com.geccocrawler.gecco.response.HttpResponse;
import com.geccocrawler.gecco.spider.SpiderBean;
import com.geccocrawler.gecco.spider.conversion.Conversion;
import com.geccocrawler.gecco.spider.render.FieldRender;
import com.geccocrawler.gecco.spider.render.FieldRenderException;
import com.geccocrawler.gecco.spider.render.Render;
import com.geccocrawler.gecco.spider.render.RenderContext;
import com.geccocrawler.gecco.spider.render.RenderException;
import com.geccocrawler.gecco.spider.render.RenderType;
import com.geccocrawler.gecco.utils.ReflectUtils;
import com.google.common.base.Predicate;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.sf.cglib.beans.BeanMap;
import org.apache.commons.lang3.StringUtils;
import org.reflections.ReflectionUtils;

public class JsonFieldRender
implements FieldRender {
    @Override
    public void render(HttpRequest request, HttpResponse response, BeanMap beanMap, SpiderBean bean) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        Set jsonPathFields = ReflectionUtils.getAllFields(bean.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(com.geccocrawler.gecco.annotation.JSONPath.class)});
        String jsonStr = response.getContent();
        if ((jsonStr = this.jsonp2Json(jsonStr)) == null) {
            return;
        }
        try {
            Object json = JSON.parse((String)jsonStr);
            for (Field field : jsonPathFields) {
                Object value = this.injectJsonField(request, field, json);
                if (value == null) continue;
                fieldMap.put(field.getName(), value);
            }
        }
        catch (JSONException ex) {
            RenderException.log("json parse error : " + request.getUrl(), bean.getClass(), ex);
        }
        beanMap.putAll(fieldMap);
    }

    private Object injectJsonField(HttpRequest request, Field field, Object json) {
        com.geccocrawler.gecco.annotation.JSONPath JSONPath2 = field.getAnnotation(com.geccocrawler.gecco.annotation.JSONPath.class);
        String jsonPath = JSONPath2.value();
        Class<?> type = field.getType();
        Object src = JSONPath.eval((Object)json, (String)jsonPath);
        boolean isArray = type.isArray();
        boolean isList = ReflectUtils.haveSuperType(type, List.class);
        if (isList) {
            Type genericType = field.getGenericType();
            Class genericClass = ReflectUtils.getGenericClass(genericType, 0);
            if (ReflectUtils.haveSuperType(genericClass, SpiderBean.class)) {
                return this.spiderBeanListRender(src, genericClass, request);
            }
            return this.objectRender(src, field, jsonPath, json);
        }
        if (isArray) {
            Class<?> genericClass = type.getComponentType();
            if (ReflectUtils.haveSuperType(genericClass, SpiderBean.class)) {
                List<SpiderBean> list = this.spiderBeanListRender(src, genericClass, request);
                SpiderBean[] a = (SpiderBean[])Array.newInstance(genericClass, list.size());
                return list.toArray(a);
            }
            return ((List)this.objectRender(src, field, jsonPath, json)).toArray();
        }
        if (ReflectUtils.haveSuperType(type, SpiderBean.class)) {
            return this.spiderBeanRender(src, type, request);
        }
        return this.objectRender(src, field, jsonPath, json);
    }

    private List<SpiderBean> spiderBeanListRender(Object src, Class genericClass, HttpRequest request) {
        ArrayList<SpiderBean> list = new ArrayList<SpiderBean>();
        JSONArray ja = (JSONArray)src;
        for (Object jo : ja) {
            SpiderBean subBean = this.spiderBeanRender(jo, genericClass, request);
            list.add(subBean);
        }
        return list;
    }

    private SpiderBean spiderBeanRender(Object src, Class genericClass, HttpRequest request) {
        HttpResponse subResponse = HttpResponse.createSimple(src.toString());
        Render render = RenderContext.getRender(RenderType.JSON);
        SpiderBean subBean = render.inject(genericClass, request, subResponse);
        return subBean;
    }

    private Object objectRender(Object src, Field field, String jsonPath, Object json) {
        if (src == null) {
            FieldRenderException.log(field, String.valueOf(jsonPath) + " not found in : " + json);
        }
        try {
            return Conversion.getValue(field.getType(), src);
        }
        catch (Exception ex) {
            FieldRenderException.log(field, "Conversion error : " + src, ex);
            return null;
        }
    }

    private String jsonp2Json(String jsonp) {
        if (jsonp == null) {
            return null;
        }
        if (StringUtils.endsWith((CharSequence)(jsonp = StringUtils.trim((String)jsonp)), (CharSequence)";")) {
            jsonp = StringUtils.substringBeforeLast((String)jsonp, (String)";");
            jsonp = StringUtils.trim((String)jsonp);
        }
        if (StringUtils.endsWith((CharSequence)jsonp, (CharSequence)")")) {
            String jsonStr = StringUtils.substringBetween((String)jsonp, (String)"(", (String)")");
            jsonStr = StringUtils.trim((String)jsonStr);
            return jsonStr;
        }
        return jsonp;
    }
}

