/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.spider.render.html;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONPath;
import com.geccocrawler.gecco.annotation.JSVar;
import com.geccocrawler.gecco.request.HttpRequest;
import com.geccocrawler.gecco.response.HttpResponse;
import com.geccocrawler.gecco.spider.SpiderBean;
import com.geccocrawler.gecco.spider.conversion.Conversion;
import com.geccocrawler.gecco.spider.render.FieldRender;
import com.geccocrawler.gecco.spider.render.html.HtmlParser;
import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Set;
import net.sf.cglib.beans.BeanMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.nodes.Element;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJSON;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.reflections.ReflectionUtils;

public class JSVarFieldRender
implements FieldRender {
    private static Log log = LogFactory.getLog(JSVarFieldRender.class);

    @Override
    public void render(HttpRequest request, HttpResponse response, BeanMap beanMap, SpiderBean bean) {
        Context cx = Context.enter();
        ScriptableObject scope = cx.initSafeStandardObjects();
        String windowScript = "var window = {};var document = {};";
        cx.evaluateString((Scriptable)scope, windowScript, "window", 1, null);
        HtmlParser parser = new HtmlParser(request.getUrl(), response.getContent());
        for (Element ele : parser.$("script")) {
            String sc = ele.html();
            if (!StringUtils.isNotEmpty((CharSequence)sc)) continue;
            try {
                cx.evaluateString((Scriptable)scope, sc, "", 1, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        Set jsVarFields = ReflectionUtils.getAllFields(bean.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(JSVar.class)});
        for (Field jsVarField : jsVarFields) {
            Object value = this.injectJsVarField(request, beanMap, jsVarField, cx, scope);
            if (value == null) continue;
            fieldMap.put(jsVarField.getName(), value);
        }
        beanMap.putAll(fieldMap);
        Context.exit();
    }

    private Object injectJsVarField(HttpRequest request, BeanMap beanMap, Field field, Context cx, ScriptableObject scope) {
        Class<?> clazz = field.getType();
        JSVar jsVar = field.getAnnotation(JSVar.class);
        String var = jsVar.var();
        Object jsObj = scope.get(var, (Scriptable)scope);
        if (jsObj instanceof NativeObject || jsObj instanceof NativeArray) {
            String jsonPath = jsVar.jsonpath();
            Object jsonObj = NativeJSON.stringify((Context)cx, (Scriptable)scope, (Object)jsObj, null, null);
            Object json = JSON.parse((String)jsonObj.toString());
            Object src = JSONPath.eval((Object)json, (String)jsonPath);
            try {
                if (src instanceof String) {
                    src = JSON.parse((String)src.toString());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                Object value = Conversion.getValue(clazz, src);
                return value;
            }
            catch (Exception e) {
                log.error((Object)("field [" + field.getName() + "] conversion error, value=" + src));
            }
        } else if (jsObj instanceof Boolean || jsObj instanceof Number || jsObj instanceof String) {
            try {
                Object value = Conversion.getValue(clazz, jsObj);
                return value;
            }
            catch (Exception e) {
                log.error((Object)("field [" + field.getName() + "] conversion error, value=" + jsObj));
            }
        }
        return null;
    }

    public static void main(String[] args) {
        Object json = JSON.parse((String)"{ads:[{id:1},{id:2}],test:'test111'}");
        Object src = JSONPath.eval((Object)json, (String)"$.ads");
        if (src instanceof String) {
            src = JSON.parse((String)src.toString());
        }
        System.out.println(src);
        Object src2 = JSONPath.eval((Object)json, (String)"$.test");
        if (src2 instanceof String) {
            src2 = JSON.parse((String)src2.toString());
        }
        System.out.println(src2);
    }
}

