/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.spider.render.html;

import com.geccocrawler.gecco.annotation.Image;
import com.geccocrawler.gecco.downloader.DownloaderContext;
import com.geccocrawler.gecco.request.HttpRequest;
import com.geccocrawler.gecco.response.HttpResponse;
import com.geccocrawler.gecco.spider.SpiderBean;
import com.geccocrawler.gecco.spider.render.FieldRender;
import com.geccocrawler.gecco.utils.DownloadImage;
import com.google.common.base.Predicate;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Set;
import net.sf.cglib.beans.BeanMap;
import org.apache.commons.lang3.StringUtils;
import org.reflections.ReflectionUtils;

public class ImageFieldRender
implements FieldRender {
    @Override
    public void render(HttpRequest request, HttpResponse response, BeanMap beanMap, SpiderBean bean) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        Set imageFields = ReflectionUtils.getAllFields(bean.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Image.class)});
        for (Field imageField : imageFields) {
            Object value = this.injectImageField(request, beanMap, bean, imageField);
            if (value == null) continue;
            fieldMap.put(imageField.getName(), value);
        }
        beanMap.putAll(fieldMap);
    }

    private Object injectImageField(HttpRequest request, BeanMap beanMap, SpiderBean bean, Field field) {
        Object value = beanMap.get((Object)field.getName());
        if (value == null) {
            return null;
        }
        String imgUrl = value.toString();
        if (StringUtils.isEmpty((CharSequence)imgUrl)) {
            return imgUrl;
        }
        Image image = field.getAnnotation(Image.class);
        String parentPath = image.download();
        if (StringUtils.isEmpty((CharSequence)parentPath)) {
            return imgUrl;
        }
        try (HttpResponse subReponse = null;){
            String before = StringUtils.substringBefore((String)imgUrl, (String)"?");
            String last = StringUtils.substringAfter((String)imgUrl, (String)"?");
            String fileName = StringUtils.substringAfterLast((String)before, (String)"/");
            if (StringUtils.isNotEmpty((CharSequence)last)) {
                last = URLEncoder.encode(last, "UTF-8");
                imgUrl = String.valueOf(before) + "?" + last;
            }
            HttpRequest subRequest = request.subRequest(imgUrl);
            subReponse = DownloaderContext.defaultDownload(subRequest);
            String string = DownloadImage.download(parentPath, fileName, subReponse.getRaw());
            return string;
        }
    }
}

