/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.spider.render.html;

import com.geccocrawler.gecco.annotation.Attr;
import com.geccocrawler.gecco.annotation.Href;
import com.geccocrawler.gecco.annotation.Html;
import com.geccocrawler.gecco.annotation.Image;
import com.geccocrawler.gecco.annotation.Text;
import com.geccocrawler.gecco.request.HttpRequest;
import com.geccocrawler.gecco.response.HttpResponse;
import com.geccocrawler.gecco.spider.SpiderBean;
import com.geccocrawler.gecco.spider.SpiderThreadLocal;
import com.geccocrawler.gecco.spider.conversion.Conversion;
import com.geccocrawler.gecco.spider.render.Render;
import com.geccocrawler.gecco.spider.render.RenderContext;
import com.geccocrawler.gecco.spider.render.RenderType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class HtmlParser {
    private Log log;
    private Document document;
    private String baseUri;

    public HtmlParser(String baseUri, String content) {
        long beginTime = System.currentTimeMillis();
        this.log = LogFactory.getLog(HtmlParser.class);
        this.baseUri = baseUri;
        this.document = this.isTable(content) ? Jsoup.parse((String)content, (String)baseUri, (Parser)Parser.xmlParser()) : Jsoup.parse((String)content, (String)baseUri);
        long endTime = System.currentTimeMillis();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("init html parser : " + (endTime - beginTime) + "ms"));
        }
    }

    public String baseUri() {
        return this.baseUri;
    }

    public Object $basic(String selector, Field field) throws Exception {
        if (field.isAnnotationPresent(Text.class)) {
            Text text = field.getAnnotation(Text.class);
            String value = this.$text(selector, text.own());
            return Conversion.getValue(field.getType(), value);
        }
        if (field.isAnnotationPresent(Image.class)) {
            Image image = field.getAnnotation(Image.class);
            String imageSrc = this.$image(selector, image.value());
            return imageSrc;
        }
        if (field.isAnnotationPresent(Href.class)) {
            Href href = field.getAnnotation(Href.class);
            String url = this.$href(selector, href.value());
            return url;
        }
        if (field.isAnnotationPresent(Attr.class)) {
            Attr attr = field.getAnnotation(Attr.class);
            String name = attr.value();
            return Conversion.getValue(field.getType(), this.$attr(selector, name));
        }
        if (field.isAnnotationPresent(Html.class)) {
            Html html = field.getAnnotation(Html.class);
            return this.$html(selector, html.outer());
        }
        return this.$html(selector);
    }

    public List<Object> $basicList(String selector, Field field) throws Exception {
        ArrayList<Object> list = new ArrayList<Object>();
        Elements els = this.$(selector);
        for (Element el : els) {
            if (field.isAnnotationPresent(Text.class)) {
                Text text = field.getAnnotation(Text.class);
                list.add(Conversion.getValue(field.getType(), this.$text(el, text.own())));
                continue;
            }
            if (field.isAnnotationPresent(Image.class)) {
                Image image = field.getAnnotation(Image.class);
                String imageSrc = this.$image(el, image.value());
                list.add(imageSrc);
                continue;
            }
            if (field.isAnnotationPresent(Href.class)) {
                Href href = field.getAnnotation(Href.class);
                String url = this.$href(el, href.value());
                list.add(url);
                continue;
            }
            if (field.isAnnotationPresent(Attr.class)) {
                Attr attr = field.getAnnotation(Attr.class);
                String name = attr.value();
                list.add(Conversion.getValue(field.getType(), this.$attr(el, name)));
                continue;
            }
            if (field.isAnnotationPresent(Html.class)) {
                Html html = field.getAnnotation(Html.class);
                list.add(html.outer() ? el.outerHtml() : el.html());
                continue;
            }
            list.add(el.html());
        }
        return list;
    }

    public SpiderBean $bean(String selector, HttpRequest request, Class<? extends SpiderBean> clazz) {
        String subHtml = this.$html(selector);
        HttpResponse subResponse = HttpResponse.createSimple(subHtml);
        Render render = RenderContext.getRender(RenderType.HTML);
        return render.inject(clazz, request, subResponse);
    }

    public List<SpiderBean> $beanList(String selector, HttpRequest request, Class<? extends SpiderBean> clazz) {
        ArrayList<SpiderBean> list = new ArrayList<SpiderBean>();
        List<String> els = this.$list(selector);
        for (String el : els) {
            HttpResponse subResponse = HttpResponse.createSimple(el);
            Render render = RenderContext.getRender(RenderType.HTML);
            SpiderBean subBean = render.inject(clazz, request, subResponse);
            list.add(subBean);
        }
        return list;
    }

    public Elements $(String selector) {
        Elements elements = this.document.select(selector);
        if (SpiderThreadLocal.get().getEngine().isDebug() && !selector.equalsIgnoreCase("script")) {
            System.out.println("[" + selector + "]--->[" + elements + "]");
        }
        return elements;
    }

    public Element $element(String selector) {
        Elements elements = this.$(selector);
        if (elements != null && elements.size() > 0) {
            return elements.first();
        }
        return null;
    }

    public List<String> $list(String selector) {
        ArrayList<String> list = new ArrayList<String>();
        Elements elements = this.$(selector);
        if (elements != null) {
            for (Element ele : elements) {
                list.add(ele.outerHtml());
            }
        }
        return list;
    }

    public String $html(String selector) {
        return this.$html(selector, false);
    }

    public String $html(String selector, boolean isOuter) {
        Elements elements = this.$(selector);
        if (elements != null) {
            if (isOuter) {
                return elements.outerHtml();
            }
            return elements.html();
        }
        return null;
    }

    public String $text(Element element, boolean own) {
        if (element == null) {
            return null;
        }
        String text = "";
        text = own ? element.ownText() : element.text();
        return StringUtils.replace((String)text, (String)"\u00a0", (String)"");
    }

    public String $text(String selector, boolean own) {
        Element element = this.$element(selector);
        if (element != null) {
            return this.$text(element, own);
        }
        return null;
    }

    public String $attr(Element element, String attr) {
        if (element == null) {
            return null;
        }
        return element.attr(attr);
    }

    public String $attr(String selector, String attr) {
        Element element = this.$element(selector);
        if (element == null) {
            return null;
        }
        return element.attr(attr);
    }

    public String $href(Element href, String attr) {
        if (href == null) {
            return null;
        }
        return href.absUrl(attr);
    }

    public String $href(Element href, String ... attrs) {
        if (href == null) {
            return null;
        }
        String[] stringArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            String value = this.$href(href, attr);
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                return value;
            }
            ++n2;
        }
        return this.$href(href, "href");
    }

    public String $href(String selector, String attr) {
        return this.$href(this.$element(selector), attr);
    }

    public String $href(String selector, String ... attrs) {
        return this.$href(this.$element(selector), attrs);
    }

    public String $image(Element img, String attr) {
        if (img == null) {
            return null;
        }
        return img.absUrl(attr);
    }

    public String $image(Element img, String ... attrs) {
        if (img == null) {
            return null;
        }
        String[] stringArray = attrs;
        int n = attrs.length;
        int n2 = 0;
        while (n2 < n) {
            String attr = stringArray[n2];
            String value = this.$image(img, attr);
            if (StringUtils.isNotEmpty((CharSequence)value)) {
                return value;
            }
            ++n2;
        }
        return this.$image(img, "src");
    }

    public String $image(String selector, String attr) {
        return this.$image(this.$element(selector), attr);
    }

    public String $image(String selector, String ... attrs) {
        return this.$image(this.$element(selector), attrs);
    }

    public void setLogClass(Class<? extends SpiderBean> spiderBeanClass) {
        this.log = LogFactory.getLog(spiderBeanClass);
    }

    private boolean isTable(String content) {
        String rege;
        Pattern pattern;
        Matcher matcher;
        return !StringUtils.contains((CharSequence)content, (CharSequence)"</html>") && (matcher = (pattern = Pattern.compile(rege = "<\\s*(tr|td|th)[\\s\\S]+")).matcher(content)).matches();
    }
}

