/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.spider.render.html;

import com.geccocrawler.gecco.annotation.HtmlField;
import com.geccocrawler.gecco.request.HttpRequest;
import com.geccocrawler.gecco.response.HttpResponse;
import com.geccocrawler.gecco.spider.SpiderBean;
import com.geccocrawler.gecco.spider.render.FieldRender;
import com.geccocrawler.gecco.spider.render.FieldRenderException;
import com.geccocrawler.gecco.spider.render.html.HtmlParser;
import com.geccocrawler.gecco.utils.ReflectUtils;
import com.google.common.base.Predicate;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.sf.cglib.beans.BeanMap;
import org.reflections.ReflectionUtils;

public class HtmlFieldRender
implements FieldRender {
    @Override
    public void render(HttpRequest request, HttpResponse response, BeanMap beanMap, SpiderBean bean) {
        HashMap<String, Object> fieldMap = new HashMap<String, Object>();
        Set htmlFields = ReflectionUtils.getAllFields(bean.getClass(), (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(HtmlField.class)});
        for (Field htmlField : htmlFields) {
            Object value = this.injectHtmlField(request, response, htmlField, bean.getClass());
            if (value == null) continue;
            fieldMap.put(htmlField.getName(), value);
        }
        beanMap.putAll(fieldMap);
    }

    private Object injectHtmlField(HttpRequest request, HttpResponse response, Field field, Class<? extends SpiderBean> clazz) {
        HtmlField htmlField = field.getAnnotation(HtmlField.class);
        String content = response.getContent();
        HtmlParser parser = new HtmlParser(request.getUrl(), content);
        String cssPath = htmlField.cssPath();
        Class<?> type = field.getType();
        boolean isArray = type.isArray();
        boolean isList = ReflectUtils.haveSuperType(type, List.class);
        if (isList) {
            Type genericType = field.getGenericType();
            Class genericClass = ReflectUtils.getGenericClass(genericType, 0);
            if (ReflectUtils.haveSuperType(genericClass, SpiderBean.class)) {
                return parser.$beanList(cssPath, request, genericClass);
            }
            try {
                return parser.$basicList(cssPath, field);
            }
            catch (Exception ex) {
                FieldRenderException.log(field, content, ex);
            }
        } else if (isArray) {
            Class<?> genericClass = type.getComponentType();
            if (ReflectUtils.haveSuperType(genericClass, SpiderBean.class)) {
                List<SpiderBean> list = parser.$beanList(cssPath, request, genericClass);
                SpiderBean[] a = (SpiderBean[])Array.newInstance(genericClass, list.size());
                return list.toArray(a);
            }
            try {
                return parser.$basicList(cssPath, field).toArray();
            }
            catch (Exception ex) {
                FieldRenderException.log(field, content, ex);
            }
        } else {
            if (ReflectUtils.haveSuperType(type, SpiderBean.class)) {
                return parser.$bean(cssPath, request, type);
            }
            try {
                return parser.$basic(cssPath, field);
            }
            catch (Exception ex) {
                FieldRenderException.log(field, content, ex);
            }
        }
        return null;
    }
}

