/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.spider.conversion;

import com.geccocrawler.gecco.spider.conversion.BooleanTypeHandle;
import com.geccocrawler.gecco.spider.conversion.DateTypeHandle;
import com.geccocrawler.gecco.spider.conversion.DoubleTypeHandle;
import com.geccocrawler.gecco.spider.conversion.FloatTypeHandle;
import com.geccocrawler.gecco.spider.conversion.IntegerTypeHandle;
import com.geccocrawler.gecco.spider.conversion.LongTypeHandle;
import com.geccocrawler.gecco.spider.conversion.TypeHandle;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Conversion {
    private static final Map<Class<?>, TypeHandle> TYPE_HANDLERS = new HashMap();

    static {
        TYPE_HANDLERS.put(Integer.class, new IntegerTypeHandle());
        TYPE_HANDLERS.put(Integer.TYPE, new IntegerTypeHandle());
        TYPE_HANDLERS.put(Long.class, new LongTypeHandle());
        TYPE_HANDLERS.put(Long.TYPE, new LongTypeHandle());
        TYPE_HANDLERS.put(Float.class, new FloatTypeHandle());
        TYPE_HANDLERS.put(Float.TYPE, new FloatTypeHandle());
        TYPE_HANDLERS.put(Double.class, new DoubleTypeHandle());
        TYPE_HANDLERS.put(Double.TYPE, new DoubleTypeHandle());
        TYPE_HANDLERS.put(Boolean.class, new BooleanTypeHandle());
        TYPE_HANDLERS.put(Boolean.TYPE, new BooleanTypeHandle());
        TYPE_HANDLERS.put(Date.class, new DateTypeHandle());
    }

    public static void register(Class<?> type, TypeHandle typeHandle) {
        TYPE_HANDLERS.put(type, typeHandle);
    }

    public static void unregister(Class<?> type) {
        TYPE_HANDLERS.remove(type);
    }

    public static Object getValue(Class<?> type, Object value) throws Exception {
        TypeHandle th = TYPE_HANDLERS.get(type);
        if (th != null && value != null) {
            return th.getValue(value);
        }
        return value;
    }

    public static Object getDateValue(Object value, String format) throws Exception {
        DateTypeHandle th = (DateTypeHandle)TYPE_HANDLERS.get(Date.class);
        return th.getValue(value, format);
    }
}

