/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.scheduler;

import com.geccocrawler.gecco.request.HttpRequest;
import com.geccocrawler.gecco.scheduler.Scheduler;
import java.util.Comparator;
import java.util.NavigableSet;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UniqueSpiderScheduler
implements Scheduler {
    private static Log log = LogFactory.getLog(UniqueSpiderScheduler.class);
    private NavigableSet<SortHttpRequest> set = new ConcurrentSkipListSet<SortHttpRequest>(new Comparator<SortHttpRequest>(){

        @Override
        public int compare(SortHttpRequest o1, SortHttpRequest o2) {
            if (o1.getHttpRequest().hashCode() == o2.getHttpRequest().hashCode() && o1.getHttpRequest().equals(o2.getHttpRequest())) {
                return 0;
            }
            return o1.getPriority() - o2.getPriority() > 0L ? 1 : -1;
        }
    });

    @Override
    public HttpRequest out() {
        SortHttpRequest sortHttpRequest = this.set.pollFirst();
        if (sortHttpRequest == null) {
            return null;
        }
        long priority = sortHttpRequest.getPriority();
        HttpRequest request = sortHttpRequest.getHttpRequest();
        if (request != null && log.isDebugEnabled()) {
            log.debug((Object)("OUT(" + priority + "):" + request.getUrl() + "(Referer:" + request.getHeaders().get("Referer") + ")"));
        }
        return request;
    }

    @Override
    public void into(HttpRequest request) {
        long priority = System.nanoTime();
        boolean success = this.set.add(new SortHttpRequest(priority, request));
        if (success && log.isDebugEnabled()) {
            log.debug((Object)("INTO(" + priority + "):" + request.getUrl() + "(Referer:" + request.getHeaders().get("Referer") + ")"));
        }
        if (!success && log.isDebugEnabled()) {
            log.error((Object)("not unique request : " + request.getUrl()));
        }
    }

    private class SortHttpRequest {
        private long priority;
        private HttpRequest httpRequest;

        public SortHttpRequest(long priority, HttpRequest httpRequest) {
            this.priority = priority;
            this.httpRequest = httpRequest;
        }

        public long getPriority() {
            return this.priority;
        }

        public HttpRequest getHttpRequest() {
            return this.httpRequest;
        }
    }
}

