/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.response;

import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class HttpResponse {
    private ByteArrayInputStream raw;
    private String content;
    private String contentType;
    private String charset;
    private int status;

    public static HttpResponse createSimple(String content) {
        HttpResponse response = new HttpResponse();
        response.setContent(content);
        return response;
    }

    public ByteArrayInputStream getRaw() {
        return this.raw;
    }

    public void setRaw(ByteArrayInputStream raw) {
        this.raw = raw;
    }

    public String getContent() {
        return this.content;
    }

    public String getContent(String charset) {
        if (charset == null) {
            return this.content;
        }
        try {
            return CharStreams.toString((Readable)new InputStreamReader((InputStream)this.raw, charset));
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.content;
        }
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void close() {
        if (this.raw != null) {
            try {
                this.raw.close();
            }
            catch (Exception ex) {
                this.raw = null;
            }
        }
    }
}

