/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.dynamic;

import com.geccocrawler.gecco.annotation.Ajax;
import com.geccocrawler.gecco.annotation.Attr;
import com.geccocrawler.gecco.annotation.FieldRenderName;
import com.geccocrawler.gecco.annotation.Href;
import com.geccocrawler.gecco.annotation.Html;
import com.geccocrawler.gecco.annotation.HtmlField;
import com.geccocrawler.gecco.annotation.Image;
import com.geccocrawler.gecco.annotation.JSONPath;
import com.geccocrawler.gecco.annotation.Request;
import com.geccocrawler.gecco.annotation.RequestParameter;
import com.geccocrawler.gecco.annotation.Text;
import com.geccocrawler.gecco.dynamic.DynamicBean;
import com.geccocrawler.gecco.dynamic.DynamicField;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavassistDynamicField
implements DynamicField {
    private static Log log = LogFactory.getLog(JavassistDynamicField.class);
    private DynamicBean dynamicBean;
    private CtField cfield;
    private ConstPool cpool;
    private AnnotationsAttribute attr;

    public JavassistDynamicField(DynamicBean dynamicBean, CtClass clazz, ConstPool cpool, String fieldName) {
        try {
            this.dynamicBean = dynamicBean;
            this.cpool = cpool;
            this.cfield = clazz.getField(fieldName);
            this.attr = new AnnotationsAttribute(cpool, "RuntimeVisibleAnnotations");
        }
        catch (NotFoundException e) {
            log.error((Object)(String.valueOf(fieldName) + " not found"));
        }
    }

    @Override
    public DynamicBean build() {
        FieldInfo finfo = this.cfield.getFieldInfo();
        finfo.addAttribute((AttributeInfo)this.attr);
        return this.dynamicBean;
    }

    @Override
    @Deprecated
    public DynamicField htmlField(String cssPath) {
        return this.csspath(cssPath);
    }

    @Override
    public DynamicField csspath(String cssPath) {
        Annotation annot = new Annotation(HtmlField.class.getName(), this.cpool);
        annot.addMemberValue("cssPath", (MemberValue)new StringMemberValue(cssPath, this.cpool));
        this.attr.addAnnotation(annot);
        return this;
    }

    @Override
    public DynamicField text(boolean own) {
        Annotation annot = new Annotation(Text.class.getName(), this.cpool);
        annot.addMemberValue("own", (MemberValue)new BooleanMemberValue(own, this.cpool));
        this.attr.addAnnotation(annot);
        return this;
    }

    @Override
    public DynamicField text() {
        return this.text(true);
    }

    @Override
    public DynamicField html(boolean outer) {
        Annotation annot = new Annotation(Html.class.getName(), this.cpool);
        annot.addMemberValue("outer", (MemberValue)new BooleanMemberValue(outer, this.cpool));
        this.attr.addAnnotation(annot);
        return this;
    }

    @Override
    public DynamicField href(boolean click, String ... value) {
        Annotation annot = new Annotation(Href.class.getName(), this.cpool);
        annot.addMemberValue("click", (MemberValue)new BooleanMemberValue(click, this.cpool));
        ArrayMemberValue arrayMemberValue = new ArrayMemberValue(this.cpool);
        StringMemberValue[] memberValues = new StringMemberValue[value.length];
        int i = 0;
        while (i < value.length) {
            memberValues[i] = new StringMemberValue(value[i], this.cpool);
            ++i;
        }
        arrayMemberValue.setValue((MemberValue[])memberValues);
        annot.addMemberValue("value", (MemberValue)arrayMemberValue);
        this.attr.addAnnotation(annot);
        return this;
    }

    @Override
    public DynamicField href(String ... value) {
        return this.href(false, value);
    }

    @Override
    public DynamicField image(String download, String ... value) {
        Annotation annot = new Annotation(Image.class.getName(), this.cpool);
        annot.addMemberValue("download", (MemberValue)new StringMemberValue(download, this.cpool));
        ArrayMemberValue arrayMemberValue = new ArrayMemberValue(this.cpool);
        StringMemberValue[] memberValues = new StringMemberValue[value.length];
        int i = 0;
        while (i < value.length) {
            memberValues[i] = new StringMemberValue(value[i], this.cpool);
            ++i;
        }
        arrayMemberValue.setValue((MemberValue[])memberValues);
        annot.addMemberValue("value", (MemberValue)arrayMemberValue);
        this.attr.addAnnotation(annot);
        return this;
    }

    @Override
    public DynamicField image() {
        return this.image("", new String[0]);
    }

    @Override
    public DynamicField attr(String value) {
        Annotation annot = new Annotation(Attr.class.getName(), this.cpool);
        annot.addMemberValue("value", (MemberValue)new StringMemberValue(value, this.cpool));
        this.attr.addAnnotation(annot);
        return this;
    }

    @Override
    public DynamicField ajax(String url) {
        Annotation annot = new Annotation(Ajax.class.getName(), this.cpool);
        annot.addMemberValue("url", (MemberValue)new StringMemberValue(url, this.cpool));
        this.attr.addAnnotation(annot);
        return this;
    }

    @Override
    public DynamicField request() {
        Annotation annot = new Annotation(Request.class.getName(), this.cpool);
        this.attr.addAnnotation(annot);
        return this;
    }

    @Override
    public DynamicField requestParameter(String param) {
        Annotation annot = new Annotation(RequestParameter.class.getName(), this.cpool);
        annot.addMemberValue("value", (MemberValue)new StringMemberValue(param, this.cpool));
        this.attr.addAnnotation(annot);
        return this;
    }

    @Override
    public DynamicField requestParameter() {
        return this.requestParameter("");
    }

    @Override
    public DynamicField jsvar(String var, String jsonpath) {
        Annotation annot = new Annotation(RequestParameter.class.getName(), this.cpool);
        annot.addMemberValue("var", (MemberValue)new StringMemberValue(var, this.cpool));
        annot.addMemberValue("jsonpath", (MemberValue)new StringMemberValue(jsonpath, this.cpool));
        this.attr.addAnnotation(annot);
        return this;
    }

    @Override
    public DynamicField jsvar(String var) {
        return this.jsvar(var, "");
    }

    @Override
    public DynamicField jsonpath(String value) {
        Annotation annot = new Annotation(JSONPath.class.getName(), this.cpool);
        annot.addMemberValue("value", (MemberValue)new StringMemberValue(value, this.cpool));
        this.attr.addAnnotation(annot);
        return this;
    }

    @Override
    public DynamicField renderName(String value) {
        Annotation renderName = new Annotation(FieldRenderName.class.getName(), this.cpool);
        renderName.addMemberValue("value", (MemberValue)new StringMemberValue(value, this.cpool));
        this.attr.addAnnotation(renderName);
        return this;
    }

    @Override
    public DynamicField customAnnotation(Annotation annotation) {
        this.attr.addAnnotation(annotation);
        return this;
    }

    @Override
    public ConstPool getConstPool() {
        return this.cpool;
    }
}

