/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.dynamic;

import com.geccocrawler.gecco.annotation.Gecco;
import com.geccocrawler.gecco.dynamic.DynamicBean;
import com.geccocrawler.gecco.dynamic.DynamicField;
import com.geccocrawler.gecco.dynamic.FieldType;
import com.geccocrawler.gecco.dynamic.GeccoClassLoader;
import com.geccocrawler.gecco.dynamic.JavassistDynamicField;
import javassist.CannotCompileException;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavassistDynamicBean
implements DynamicBean {
    private static Log log = LogFactory.getLog(JavassistDynamicBean.class);
    public static final String HtmlBean = "html";
    public static final String JsonBean = "json";
    private static ClassPool pool = ClassPool.getDefault();
    private CtClass clazz;
    private ClassFile cfile;
    private ConstPool cpool;

    static {
        pool.insertClassPath((ClassPath)new ClassClassPath(JavassistDynamicBean.class));
    }

    public JavassistDynamicBean(String spiderBeanName) {
        try {
            this.clazz = pool.get(spiderBeanName);
        }
        catch (NotFoundException e) {
            log.error((Object)(String.valueOf(spiderBeanName) + " not found"));
        }
    }

    public JavassistDynamicBean(String spiderBeanName, String beanType) {
        try {
            this.clazz = pool.get(spiderBeanName);
        }
        catch (NotFoundException e) {
            log.debug((Object)(String.valueOf(spiderBeanName) + " not found, to be create!"));
            try {
                this.clazz = pool.makeClass(spiderBeanName);
                if (beanType.equals(HtmlBean)) {
                    CtClass htmlBeanInterface = pool.get("com.geccocrawler.gecco.spider.HtmlBean");
                    this.clazz.addInterface(htmlBeanInterface);
                } else {
                    CtClass jsonBeanInterface = pool.get("com.geccocrawler.gecco.spider.JsonBean");
                    this.clazz.addInterface(jsonBeanInterface);
                }
            }
            catch (NotFoundException cex) {
                log.error((Object)("create class " + spiderBeanName + " error."), (Throwable)cex);
            }
        }
        if (this.clazz.isFrozen()) {
            this.clazz.defrost();
            log.info((Object)(String.valueOf(spiderBeanName) + " is frozen"));
        }
        this.cfile = this.clazz.getClassFile();
        this.cpool = this.cfile.getConstPool();
    }

    @Override
    public JavassistDynamicBean gecco(String matchUrl, String ... pipelines) {
        this.gecco(new String[]{matchUrl}, pipelines);
        return this;
    }

    @Override
    public JavassistDynamicBean gecco(String matchUrl, String downloader, int timeout, String ... pipelines) {
        this.gecco(new String[]{matchUrl}, "", 3000, pipelines);
        return this;
    }

    @Override
    public JavassistDynamicBean gecco(String[] matchUrl, String ... pipelines) {
        this.gecco(matchUrl, "", 3000, pipelines);
        return this;
    }

    @Override
    public JavassistDynamicBean gecco(String[] matchUrl, String downloader, int timeout, String ... pipelines) {
        AnnotationsAttribute attr = new AnnotationsAttribute(this.cpool, "RuntimeVisibleAnnotations");
        Annotation annot = new Annotation(Gecco.class.getName(), this.cpool);
        ArrayMemberValue arrayMemberValueMatchUrl = new ArrayMemberValue(this.cpool);
        StringMemberValue[] elementMatchUrls = new StringMemberValue[matchUrl.length];
        int i = 0;
        while (i < matchUrl.length) {
            elementMatchUrls[i] = new StringMemberValue(matchUrl[i], this.cpool);
            ++i;
        }
        arrayMemberValueMatchUrl.setValue((MemberValue[])elementMatchUrls);
        annot.addMemberValue("matchUrl", (MemberValue)arrayMemberValueMatchUrl);
        annot.addMemberValue("downloader", (MemberValue)new StringMemberValue(downloader, this.cpool));
        annot.addMemberValue("timeout", (MemberValue)new IntegerMemberValue(this.cpool, timeout));
        ArrayMemberValue arrayMemberValue = new ArrayMemberValue(this.cpool);
        StringMemberValue[] elements = new StringMemberValue[pipelines.length];
        int i2 = 0;
        while (i2 < pipelines.length) {
            elements[i2] = new StringMemberValue(pipelines[i2], this.cpool);
            ++i2;
        }
        arrayMemberValue.setValue((MemberValue[])elements);
        annot.addMemberValue("pipelines", (MemberValue)arrayMemberValue);
        attr.addAnnotation(annot);
        this.cfile.addAttribute((AttributeInfo)attr);
        return this;
    }

    @Override
    public DynamicBean removeField(String fieldName) {
        try {
            this.clazz.removeField(this.clazz.getField(fieldName));
            this.clazz.removeMethod(this.clazz.getDeclaredMethod("get" + StringUtils.capitalize((String)fieldName)));
            this.clazz.removeMethod(this.clazz.getDeclaredMethod("set" + StringUtils.capitalize((String)fieldName)));
        }
        catch (NotFoundException e) {
            e.printStackTrace();
            log.error((Object)("can't remove field : " + fieldName));
        }
        return this;
    }

    @Override
    public DynamicField existField(String fieldName) {
        return new JavassistDynamicField(this, this.clazz, this.cpool, fieldName);
    }

    @Override
    @Deprecated
    public DynamicField field(String fieldName) {
        return this.existField(fieldName);
    }

    @Override
    public DynamicField field(String fieldName, CtClass fieldType) {
        try {
            this.clazz.getField(fieldName);
        }
        catch (NotFoundException e) {
            try {
                CtField f = new CtField(fieldType, fieldName, this.clazz);
                this.clazz.addField(f);
                this.getter(fieldName, f);
                this.setter(fieldName, f);
            }
            catch (CannotCompileException ex) {
                ex.printStackTrace();
            }
        }
        return new JavassistDynamicField(this, this.clazz, this.cpool, fieldName);
    }

    @Override
    public DynamicField field(String fieldName, Class<?> fieldClass) {
        return this.field(fieldName, FieldType.type(fieldClass));
    }

    private void getter(String fieldName, CtField field) {
        try {
            CtMethod m = CtNewMethod.getter((String)("get" + StringUtils.capitalize((String)fieldName)), (CtField)field);
            this.clazz.addMethod(m);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setter(String fieldName, CtField field) {
        try {
            CtMethod m = CtNewMethod.setter((String)("set" + StringUtils.capitalize((String)fieldName)), (CtField)field);
            this.clazz.addMethod(m);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public DynamicField stringField(String fieldName) {
        return this.field(fieldName, FieldType.stringType);
    }

    @Override
    public DynamicField intField(String fieldName) {
        return this.field(fieldName, FieldType.intType);
    }

    @Override
    public DynamicField longField(String fieldName) {
        return this.field(fieldName, FieldType.longType);
    }

    @Override
    public DynamicField floatField(String fieldName) {
        return this.field(fieldName, FieldType.floatType);
    }

    @Override
    public DynamicField doubleField(String fieldName) {
        return this.field(fieldName, FieldType.doubleType);
    }

    @Override
    public DynamicField requestField(String fieldName) {
        return this.field(fieldName, FieldType.requestType);
    }

    @Override
    public DynamicField listField(String fieldName, Class<?> memberClass) {
        return this.field(fieldName, FieldType.listType(memberClass.getName()));
    }

    @Override
    public Class<?> loadClass() {
        try {
            Class loadClass = this.clazz.toClass((ClassLoader)GeccoClassLoader.get(), null);
            log.debug((Object)("load class : " + this.clazz.getName()));
            return loadClass;
        }
        catch (CannotCompileException e) {
            e.printStackTrace();
            log.error((Object)(String.valueOf(this.clazz.getName()) + " cannot compile," + e.getMessage()));
            return null;
        }
    }

    @Override
    public Class<?> register() {
        Class<?> loadClass = this.loadClass();
        if (loadClass.getAnnotation(Gecco.class) != null) {
            GeccoClassLoader.get().addClass(loadClass.getName(), loadClass);
        }
        log.debug((Object)("register class : " + this.clazz.getName()));
        return loadClass;
    }

    @Override
    public void unloadClass() {
        if (this.clazz != null) {
            this.clazz.detach();
        }
    }

    @Override
    public ConstPool getConstPool() {
        return this.cpool;
    }
}

