/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.dynamic;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GeccoClassLoader
extends ClassLoader {
    private static final Log LOG = LogFactory.getLog(GeccoClassLoader.class);
    private Map<String, Class<?>> classes = new HashMap();
    private static GeccoClassLoader instance;

    public static synchronized GeccoClassLoader create() {
        ClassLoader parent;
        if (instance != null) {
            GeccoClassLoader.instance.classes.clear();
        }
        instance = (parent = Thread.currentThread().getContextClassLoader()) != null ? new GeccoClassLoader(parent) : new GeccoClassLoader();
        return instance;
    }

    public static synchronized GeccoClassLoader get() {
        if (instance == null) {
            instance = GeccoClassLoader.create();
        }
        return instance;
    }

    public GeccoClassLoader() {
    }

    public GeccoClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = this.classes.get(name);
        if (clazz == null) {
            throw new ClassNotFoundException(name);
        }
        LOG.debug((Object)("find from GeccoClassLoader : " + name));
        return clazz;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        LOG.debug((Object)("load from GeccoClassLoader : " + name));
        return super.loadClass(name);
    }

    public void addClass(String key, Class<?> clazz) {
        this.classes.put(key, clazz);
    }

    public Map<String, Class<?>> getClasses() {
        return this.classes;
    }
}

