/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.downloader.proxy;

import com.geccocrawler.gecco.downloader.proxy.Proxy;
import com.geccocrawler.gecco.downloader.proxy.Proxys;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;

public class FileProxys
implements Proxys {
    private static Log log = LogFactory.getLog(FileProxys.class);
    private ConcurrentLinkedQueue<Proxy> proxyQueue;
    private Map<String, Proxy> proxys = null;

    public FileProxys() {
        try {
            this.proxys = new ConcurrentHashMap<String, Proxy>();
            this.proxyQueue = new ConcurrentLinkedQueue();
            URL url = Resources.getResource((String)"proxys");
            File file = new File(url.getPath());
            List lines = Files.readLines((File)file, (Charset)Charsets.UTF_8);
            if (lines.size() > 0) {
                for (String line : lines) {
                    String[] hostPort;
                    if ((line = line.trim()).startsWith("#") || (hostPort = line.split(":")).length != 2) continue;
                    String host = hostPort[0];
                    int port = NumberUtils.toInt((String)hostPort[1], (int)80);
                    this.addProxy(host, port);
                }
            }
        }
        catch (Exception ex) {
            log.info((Object)"proxys not load");
        }
    }

    @Override
    public boolean addProxy(String host, int port) {
        return this.addProxy(host, port, null);
    }

    @Override
    public boolean addProxy(String host, int port, String src) {
        Proxy proxy = new Proxy(host, port);
        if (StringUtils.isNotEmpty((CharSequence)src)) {
            proxy.setSrc(src);
        }
        if (this.proxys.containsKey(proxy.toHostString())) {
            return false;
        }
        this.proxys.put(String.valueOf(host) + ":" + port, proxy);
        this.proxyQueue.offer(proxy);
        if (log.isDebugEnabled()) {
            log.debug((Object)("add proxy : " + host + ":" + port));
        }
        return true;
    }

    @Override
    public void failure(String host, int port) {
        Proxy proxy = this.proxys.get(String.valueOf(host) + ":" + port);
        if (proxy != null) {
            long failure = proxy.getFailureCount().incrementAndGet();
            long success = proxy.getSuccessCount().get();
            this.reProxy(proxy, success, failure);
        }
    }

    @Override
    public void success(String host, int ip) {
        Proxy proxy = this.proxys.get(String.valueOf(host) + ":" + ip);
        if (proxy != null) {
            long success = proxy.getSuccessCount().incrementAndGet();
            long failure = proxy.getFailureCount().get();
            this.reProxy(proxy, success, failure);
        }
    }

    private void reProxy(Proxy proxy, long success, long failure) {
        long sum = failure + success;
        if (sum < 20L) {
            this.proxyQueue.offer(proxy);
        } else if ((float)success / (float)sum >= 0.5f) {
            this.proxyQueue.offer(proxy);
        }
    }

    @Override
    public HttpHost getProxy() {
        if (this.proxys == null || this.proxys.size() == 0) {
            return null;
        }
        Proxy proxy = this.proxyQueue.poll();
        if (log.isDebugEnabled()) {
            log.debug((Object)("use proxy : " + proxy));
        }
        if (proxy == null) {
            return null;
        }
        return proxy.getHttpHost();
    }
}

