/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco.downloader;

import com.geccocrawler.gecco.downloader.Downloader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDownloader
implements Downloader {
    private static Log log = LogFactory.getLog(AbstractDownloader.class);
    private static final Pattern charsetPattern = Pattern.compile("(?i)\\bcharset=\\s*\"?([^\\s;\"]*)");

    private String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m = charsetPattern.matcher(contentType);
        if (m.find()) {
            return m.group(1).trim().toUpperCase();
        }
        return null;
    }

    protected String getCharset(String requestCharset, String contentType) {
        String charset = this.getCharsetFromContentType(contentType);
        if (charset == null) {
            charset = requestCharset;
        }
        if (charset == null) {
            charset = "UTF-8";
        }
        return charset;
    }

    protected ByteArrayInputStream toByteInputStream(InputStream in) {
        ByteArrayInputStream bis = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            try {
                byte[] b = new byte[1024];
                int c = 0;
                while ((c = in.read(b)) != -1) {
                    bos.write(b, 0, c);
                }
                b = null;
                bis = new ByteArrayInputStream(bos.toByteArray());
            }
            catch (EOFException eof) {
                bis = new ByteArrayInputStream(bos.toByteArray());
                log.warn((Object)("inputstream " + in.getClass().getName() + " eof!"));
                try {
                    in.close();
                    bos.close();
                }
                catch (IOException e) {
                    bos = null;
                    in = null;
                }
            }
            catch (IOException e) {
                log.warn((Object)("inputstream " + in.getClass().getName() + " don't to byte inputstream!"));
                try {
                    in.close();
                    bos.close();
                }
                catch (IOException e2) {
                    bos = null;
                    in = null;
                }
                return null;
            }
        }
        finally {
            try {
                in.close();
                bos.close();
            }
            catch (IOException e) {
                bos = null;
                in = null;
            }
        }
        return bis;
    }
}

