/*
 * Decompiled with CFR 0.152.
 */
package com.geccocrawler.gecco;

import com.alibaba.fastjson.JSON;
import com.geccocrawler.gecco.downloader.proxy.FileProxys;
import com.geccocrawler.gecco.downloader.proxy.Proxys;
import com.geccocrawler.gecco.dynamic.DynamicGecco;
import com.geccocrawler.gecco.dynamic.GeccoClassLoader;
import com.geccocrawler.gecco.listener.EventListener;
import com.geccocrawler.gecco.monitor.GeccoJmx;
import com.geccocrawler.gecco.monitor.GeccoMonitor;
import com.geccocrawler.gecco.pipeline.PipelineFactory;
import com.geccocrawler.gecco.request.HttpGetRequest;
import com.geccocrawler.gecco.request.HttpRequest;
import com.geccocrawler.gecco.request.StartRequestList;
import com.geccocrawler.gecco.scheduler.NoLoopStartScheduler;
import com.geccocrawler.gecco.scheduler.Scheduler;
import com.geccocrawler.gecco.scheduler.StartScheduler;
import com.geccocrawler.gecco.spider.Spider;
import com.geccocrawler.gecco.spider.SpiderBeanFactory;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class GeccoEngine
extends Thread {
    private static Log log = LogFactory.getLog(GeccoEngine.class);
    private Date startTime;
    private List<HttpRequest> startRequests = new ArrayList<HttpRequest>();
    private Scheduler scheduler;
    private SpiderBeanFactory spiderBeanFactory;
    private PipelineFactory pipelineFactory;
    private List<Spider> spiders;
    private String classpath;
    private int threadCount;
    private CountDownLatch cdl;
    private int interval;
    private Proxys proxysLoader;
    private boolean proxy = true;
    private boolean loop;
    private boolean mobile;
    private boolean debug;
    private int retry = 3;
    private EventListener eventListener;

    private GeccoEngine() {
    }

    public static GeccoEngine create() {
        GeccoEngine geccoEngine = new GeccoEngine();
        geccoEngine.setName("GeccoEngine");
        return geccoEngine;
    }

    public static GeccoEngine create(String classpath) {
        return GeccoEngine.create(classpath, null);
    }

    public static GeccoEngine create(String classpath, PipelineFactory pipelineFactory) {
        if (StringUtils.isEmpty((CharSequence)classpath)) {
            throw new IllegalArgumentException("classpath cannot be empty");
        }
        GeccoEngine ge = GeccoEngine.create();
        ge.spiderBeanFactory = new SpiderBeanFactory(classpath, pipelineFactory);
        return ge;
    }

    public GeccoEngine start(String url) {
        return this.start(new HttpGetRequest(url));
    }

    public GeccoEngine start(String ... urls) {
        String[] stringArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            String url = stringArray[n2];
            this.start(url);
            ++n2;
        }
        return this;
    }

    public GeccoEngine start(HttpRequest request) {
        this.startRequests.add(request);
        return this;
    }

    public GeccoEngine start(List<HttpRequest> requests) {
        for (HttpRequest request : requests) {
            this.start(request);
        }
        return this;
    }

    public GeccoEngine scheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public GeccoEngine thread(int count) {
        this.threadCount = count;
        return this;
    }

    public GeccoEngine interval(int interval) {
        this.interval = interval;
        return this;
    }

    public GeccoEngine retry(int retry) {
        this.retry = retry;
        return this;
    }

    public GeccoEngine loop(boolean loop) {
        this.loop = loop;
        return this;
    }

    public GeccoEngine proxysLoader(Proxys proxysLoader) {
        this.proxysLoader = proxysLoader;
        return this;
    }

    public GeccoEngine proxy(boolean proxy) {
        this.proxy = proxy;
        return this;
    }

    public GeccoEngine mobile(boolean mobile) {
        this.mobile = mobile;
        return this;
    }

    public GeccoEngine debug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public GeccoEngine classpath(String classpath) {
        this.classpath = classpath;
        return this;
    }

    public GeccoEngine pipelineFactory(PipelineFactory pipelineFactory) {
        this.pipelineFactory = pipelineFactory;
        return this;
    }

    public GeccoEngine spiderBeanFactory(SpiderBeanFactory spiderBeanFactory) {
        this.spiderBeanFactory = spiderBeanFactory;
        return this;
    }

    public void register(Class<?> spiderBeanClass) {
        this.getSpiderBeanFactory().addSpiderBean(spiderBeanClass);
    }

    public void unregister(Class<?> spiderBeanClass) {
        this.getSpiderBeanFactory().removeSpiderBean(spiderBeanClass);
        DynamicGecco.unregister(spiderBeanClass);
    }

    @Override
    public void run() {
        if (this.debug) {
            Logger log = LogManager.getLogger((String)"com.geccocrawler.gecco.spider.render");
            log.setLevel(Level.DEBUG);
        }
        if (this.proxysLoader == null) {
            this.proxysLoader = new FileProxys();
        }
        if (this.scheduler == null) {
            this.scheduler = this.loop ? new StartScheduler() : new NoLoopStartScheduler();
        }
        if (this.spiderBeanFactory == null) {
            if (StringUtils.isEmpty((CharSequence)this.classpath)) {
                throw new IllegalArgumentException("classpath cannot be empty");
            }
            this.spiderBeanFactory = new SpiderBeanFactory(this.classpath, this.pipelineFactory);
        }
        if (this.threadCount <= 0) {
            this.threadCount = 1;
        }
        this.cdl = new CountDownLatch(this.threadCount);
        this.startsJson();
        this.startRequests.isEmpty();
        for (HttpRequest startRequest : this.startRequests) {
            this.scheduler.into(startRequest);
        }
        this.spiders = new ArrayList<Spider>(this.threadCount);
        int i = 0;
        while (i < this.threadCount) {
            Spider spider = new Spider(this);
            this.spiders.add(spider);
            Thread thread = new Thread((Runnable)spider, "T" + this.classpath + i);
            thread.start();
            ++i;
        }
        this.startTime = new Date();
        GeccoMonitor.monitor(this);
        GeccoJmx.export(this.classpath);
        this.closeUnitlComplete();
    }

    @Override
    public synchronized void start() {
        if (this.eventListener != null) {
            this.eventListener.onStart(this);
        }
        super.start();
    }

    private GeccoEngine startsJson() {
        try {
            URL url = Resources.getResource((String)"starts.json");
            File file = new File(url.getPath());
            if (file.exists()) {
                String json = Files.toString((File)file, (Charset)Charset.forName("UTF-8"));
                List list = JSON.parseArray((String)json, StartRequestList.class);
                for (StartRequestList start : list) {
                    this.start(start.toRequest());
                }
            }
        }
        catch (IllegalArgumentException ex) {
            log.info((Object)"starts.json not found");
        }
        catch (IOException ioex) {
            log.error((Object)ioex);
        }
        return this;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public SpiderBeanFactory getSpiderBeanFactory() {
        return this.spiderBeanFactory;
    }

    public int getInterval() {
        return this.interval;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public List<HttpRequest> getStartRequests() {
        return this.startRequests;
    }

    public List<Spider> getSpiders() {
        return this.spiders;
    }

    public int getRetry() {
        return this.retry;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public Proxys getProxysLoader() {
        return this.proxysLoader;
    }

    public boolean isMobile() {
        return this.mobile;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public void notifyComplete() {
        this.cdl.countDown();
    }

    public void closeUnitlComplete() {
        if (!this.loop) {
            try {
                this.cdl.await();
            }
            catch (InterruptedException e) {
                log.error((Object)e);
            }
            if (this.spiderBeanFactory != null) {
                this.spiderBeanFactory.getDownloaderFactory().closeAll();
            }
            GeccoJmx.unexport();
            log.info((Object)"close gecco!");
        }
        if (this.eventListener != null) {
            this.eventListener.onStop(this);
        }
    }

    public GeccoEngine engineStart() {
        this.start();
        return this;
    }

    public void pause() {
        if (this.spiders != null) {
            for (Spider spider : this.spiders) {
                spider.pause();
            }
        }
        if (this.eventListener != null) {
            this.eventListener.onPause(this);
        }
    }

    public void restart() {
        if (this.spiders != null) {
            for (Spider spider : this.spiders) {
                spider.restart();
            }
        }
        if (this.eventListener != null) {
            this.eventListener.onRestart(this);
        }
    }

    public void beginUpdateRule() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"begin update rule");
        }
        this.pause();
        GeccoClassLoader.create();
    }

    public void endUpdateRule() {
        this.restart();
        if (log.isDebugEnabled()) {
            log.debug((Object)"end update rule");
        }
    }

    public void engineStop() {
        if (this.spiders != null) {
            for (Spider spider : this.spiders) {
                spider.stop();
            }
        }
        if (this.eventListener != null) {
            this.eventListener.onStop(this);
        }
    }

    public EventListener getEventListener() {
        return this.eventListener;
    }

    public GeccoEngine setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
        return this;
    }
}

