/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.type;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public final class DecimalToDecimalCasts {
    public static final Signature SIGNATURE = Signature.builder().kind(FunctionKind.SCALAR).operatorType(OperatorType.CAST).typeVariableConstraints(Signature.withVariadicBound("F", "decimal"), Signature.withVariadicBound("T", "decimal")).argumentTypes(TypeSignature.parseTypeSignature((String)"F")).returnType(TypeSignature.parseTypeSignature((String)"T")).build();
    public static final SqlScalarFunction DECIMAL_TO_DECIMAL_CAST = SqlScalarFunction.builder(DecimalToDecimalCasts.class).signature(SIGNATURE).implementation(b -> b.methods("shortToShortCast").withExtraParameters(context -> {
        DecimalType argumentType = (DecimalType)context.getType("F");
        DecimalType resultType = (DecimalType)context.getType("T");
        long rescale = Decimals.longTenToNth((int)Math.abs(resultType.getScale() - argumentType.getScale()));
        return ImmutableList.of((Object)argumentType.getPrecision(), (Object)argumentType.getScale(), (Object)resultType.getPrecision(), (Object)resultType.getScale(), (Object)rescale, (Object)(rescale / 2L));
    })).implementation(b -> b.methods("shortToLongCast", "longToShortCast", "longToLongCast").withExtraParameters(context -> {
        DecimalType argumentType = (DecimalType)context.getType("F");
        DecimalType resultType = (DecimalType)context.getType("T");
        return ImmutableList.of((Object)argumentType.getPrecision(), (Object)argumentType.getScale(), (Object)resultType.getPrecision(), (Object)resultType.getScale());
    })).build();

    private DecimalToDecimalCasts() {
    }

    @UsedByGeneratedCode
    public static long shortToShortCast(long value, long sourcePrecision, long sourceScale, long resultPrecision, long resultScale, long scalingFactor, long halfOfScalingFactor) {
        long returnValue;
        if (resultScale >= sourceScale) {
            returnValue = value * scalingFactor;
        } else {
            returnValue = value / scalingFactor;
            if (value >= 0L) {
                if (value % scalingFactor >= halfOfScalingFactor) {
                    ++returnValue;
                }
            } else if (value % scalingFactor <= -halfOfScalingFactor) {
                --returnValue;
            }
        }
        if (Decimals.overflows((long)returnValue, (int)((int)resultPrecision))) {
            DecimalToDecimalCasts.throwCastException(value, sourcePrecision, sourceScale, resultPrecision, resultScale);
        }
        return returnValue;
    }

    @UsedByGeneratedCode
    public static Slice shortToLongCast(long value, long sourcePrecision, long sourceScale, long resultPrecision, long resultScale) {
        return Decimals.encodeUnscaledValue((BigInteger)DecimalToDecimalCasts.bigintToBigintCast(BigInteger.valueOf(value), sourcePrecision, sourceScale, resultPrecision, resultScale));
    }

    @UsedByGeneratedCode
    public static Slice longToLongCast(Slice value, long sourcePrecision, long sourceScale, long resultPrecision, long resultScale) {
        return Decimals.encodeUnscaledValue((BigInteger)DecimalToDecimalCasts.bigintToBigintCast(Decimals.decodeUnscaledValue((Slice)value), sourcePrecision, sourceScale, resultPrecision, resultScale));
    }

    @UsedByGeneratedCode
    public static long longToShortCast(Slice value, long sourcePrecision, long sourceScale, long resultPrecision, long resultScale) {
        return DecimalToDecimalCasts.bigintToBigintCast(Decimals.decodeUnscaledValue((Slice)value), sourcePrecision, sourceScale, resultPrecision, resultScale).longValue();
    }

    private static BigInteger bigintToBigintCast(BigInteger value, long sourcePrecision, long sourceScale, long resultPrecision, long resultScale) {
        BigDecimal bigDecimal = new BigDecimal(value, (int)sourceScale);
        if ((long)(bigDecimal = bigDecimal.setScale((int)resultScale, RoundingMode.HALF_UP)).precision() > resultPrecision) {
            DecimalToDecimalCasts.throwCastException(value, sourcePrecision, sourceScale, resultPrecision, resultScale);
        }
        return bigDecimal.unscaledValue();
    }

    private static void throwCastException(long value, long sourcePrecision, long sourceScale, long resultPrecision, long resultScale) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast DECIMAL '%s' to DECIMAL(%d, %d)", Decimals.toString((long)value, (int)((int)sourceScale)), resultPrecision, resultScale));
    }

    private static void throwCastException(BigInteger value, long sourcePrecision, long sourceScale, long resultPrecision, long resultScale) {
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot cast DECIMAL '%s' to DECIMAL(%d, %d)", Decimals.toString((BigInteger)value, (int)((int)sourceScale)), resultPrecision, resultScale));
    }
}

