/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.rewrite;

import com.facebook.presto.Session;
import com.facebook.presto.execution.ParameterExtractor;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.sql.QueryUtil;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.Analyzer;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.rewrite.StatementRewrite;
import com.facebook.presto.sql.tree.AstVisitor;
import com.facebook.presto.sql.tree.DescribeInput;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NullLiteral;
import com.facebook.presto.sql.tree.Parameter;
import com.facebook.presto.sql.tree.Relation;
import com.facebook.presto.sql.tree.Row;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SortItem;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.sql.tree.StringLiteral;
import com.facebook.presto.type.UnknownType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

final class DescribeInputRewrite
implements StatementRewrite.Rewrite {
    DescribeInputRewrite() {
    }

    @Override
    public Statement rewrite(Session session, Metadata metadata, SqlParser parser, Optional<QueryExplainer> queryExplainer, Statement node, List<Expression> parameters, AccessControl accessControl) {
        return (Statement)new Visitor(session, parser, metadata, queryExplainer, parameters, accessControl).process((Node)node, null);
    }

    private static final class Visitor
    extends AstVisitor<Node, Void> {
        private final Session session;
        private final SqlParser parser;
        private final Metadata metadata;
        private final Optional<QueryExplainer> queryExplainer;
        private final List<Expression> parameters;
        private final AccessControl accessControl;

        public Visitor(Session session, SqlParser parser, Metadata metadata, Optional<QueryExplainer> queryExplainer, List<Expression> parameters, AccessControl accessControl) {
            this.session = Objects.requireNonNull(session, "session is null");
            this.parser = parser;
            this.metadata = metadata;
            this.queryExplainer = queryExplainer;
            this.accessControl = accessControl;
            this.parameters = parameters;
        }

        protected Node visitDescribeInput(DescribeInput node, Void context) throws SemanticException {
            String sqlString = this.session.getPreparedStatement(node.getName());
            Statement statement = this.parser.createStatement(sqlString);
            Analyzer analyzer = new Analyzer(this.session, this.metadata, this.parser, this.accessControl, this.queryExplainer, this.parameters);
            Analysis analysis = analyzer.analyze(statement, true);
            List<Parameter> parameters = ParameterExtractor.getParameters(statement);
            Row[] rows = (Row[])parameters.stream().map(parameter -> Visitor.createDescribeInputRow(parameter, analysis)).toArray(Row[]::new);
            Optional<Object> limit = Optional.empty();
            if (rows.length == 0) {
                rows = new Row[]{QueryUtil.row((Expression[])new Expression[]{new NullLiteral(), new NullLiteral()})};
                limit = Optional.of("0");
            }
            return QueryUtil.simpleQuery((Select)QueryUtil.selectList((Expression[])new Expression[]{QueryUtil.identifier((String)"Position"), QueryUtil.identifier((String)"Type")}), (Relation)QueryUtil.aliased((Relation)QueryUtil.values((Row[])rows), (String)"Parameter Input", (List)ImmutableList.of((Object)"Position", (Object)"Type")), Optional.empty(), Optional.empty(), Optional.empty(), (List)QueryUtil.ordering((SortItem[])new SortItem[]{QueryUtil.ascending((String)"Position")}), limit);
        }

        private static Row createDescribeInputRow(Parameter parameter, Analysis queryAnalysis) {
            Object type = queryAnalysis.getCoercion((Expression)parameter);
            if (type == null) {
                type = UnknownType.UNKNOWN;
            }
            return QueryUtil.row((Expression[])new Expression[]{new LongLiteral(Integer.toString(parameter.getPosition())), new StringLiteral(type.getTypeSignature().getBase())});
        }

        protected Node visitNode(Node node, Void context) {
            return node;
        }
    }
}

