/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.sanity;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.SimplePlanVisitor;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.sanity.PlanSanityChecker;
import com.facebook.presto.sql.tree.FunctionCall;
import java.util.Map;

public final class VerifyNoFilteredAggregations
implements PlanSanityChecker.Checker {
    @Override
    public void validate(PlanNode plan, Session session, Metadata metadata, SqlParser sqlParser, Map<Symbol, Type> types) {
        plan.accept(new Visitor(), null);
    }

    private static class Visitor
    extends SimplePlanVisitor<Void> {
        private Visitor() {
        }

        @Override
        public Void visitAggregation(AggregationNode node, Void context) {
            super.visitAggregation(node, context);
            for (FunctionCall call : node.getAggregations().values()) {
                if (!call.getFilter().isPresent()) continue;
                throw new IllegalStateException("Generated plan contains unimplemented filtered aggregations");
            }
            return null;
        }
    }
}

