/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TopNRowNumberNode
extends PlanNode {
    private final PlanNode source;
    private final WindowNode.Specification specification;
    private final Symbol rowNumberSymbol;
    private final int maxRowCountPerPartition;
    private final boolean partial;
    private final Optional<Symbol> hashSymbol;

    @JsonCreator
    public TopNRowNumberNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="specification") WindowNode.Specification specification, @JsonProperty(value="rowNumberSymbol") Symbol rowNumberSymbol, @JsonProperty(value="maxRowCountPerPartition") int maxRowCountPerPartition, @JsonProperty(value="partial") boolean partial, @JsonProperty(value="hashSymbol") Optional<Symbol> hashSymbol) {
        super(id);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(specification, "specification is null");
        Objects.requireNonNull(rowNumberSymbol, "rowNumberSymbol is null");
        Preconditions.checkArgument((maxRowCountPerPartition > 0 ? 1 : 0) != 0, (Object)"maxRowCountPerPartition must be > 0");
        Objects.requireNonNull(hashSymbol, "hashSymbol is null");
        this.source = source;
        this.specification = specification;
        this.rowNumberSymbol = rowNumberSymbol;
        this.maxRowCountPerPartition = maxRowCountPerPartition;
        this.partial = partial;
        this.hashSymbol = hashSymbol;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.source);
    }

    @Override
    public List<Symbol> getOutputSymbols() {
        if (!this.partial) {
            return ImmutableList.copyOf((Iterable)Iterables.concat(this.source.getOutputSymbols(), (Iterable)ImmutableList.of((Object)this.rowNumberSymbol)));
        }
        return ImmutableList.copyOf(this.source.getOutputSymbols());
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public WindowNode.Specification getSpecification() {
        return this.specification;
    }

    public List<Symbol> getPartitionBy() {
        return this.specification.getPartitionBy();
    }

    public List<Symbol> getOrderBy() {
        return this.specification.getOrderBy();
    }

    public Map<Symbol, SortOrder> getOrderings() {
        return this.specification.getOrderings();
    }

    @JsonProperty
    public Symbol getRowNumberSymbol() {
        return this.rowNumberSymbol;
    }

    @JsonProperty
    public int getMaxRowCountPerPartition() {
        return this.maxRowCountPerPartition;
    }

    @JsonProperty
    public boolean isPartial() {
        return this.partial;
    }

    @JsonProperty
    public Optional<Symbol> getHashSymbol() {
        return this.hashSymbol;
    }

    @Override
    public <C, R> R accept(PlanVisitor<C, R> visitor, C context) {
        return visitor.visitTopNRowNumber(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        return new TopNRowNumberNode(this.getId(), (PlanNode)Iterables.getOnlyElement(newChildren), this.specification, this.rowNumberSymbol, this.maxRowCountPerPartition, this.partial, this.hashSymbol);
    }
}

