/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.sql.planner.optimizations.Predicates;
import com.facebook.presto.sql.planner.plan.ChildReplacer;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PlanNodeSearcher {
    private final PlanNode node;
    private Predicate<PlanNode> where = Predicates.alwaysTrue();
    private Predicate<PlanNode> skipOnly = Predicates.alwaysTrue();

    public static PlanNodeSearcher searchFrom(PlanNode node) {
        return new PlanNodeSearcher(node);
    }

    public PlanNodeSearcher(PlanNode node) {
        this.node = Objects.requireNonNull(node, "node is null");
    }

    public PlanNodeSearcher where(Predicate<PlanNode> where) {
        this.where = Objects.requireNonNull(where, "where is null");
        return this;
    }

    public PlanNodeSearcher skipOnlyWhen(Predicate<PlanNode> skipOnly) {
        this.skipOnly = Objects.requireNonNull(skipOnly, "skipOnly is null");
        return this;
    }

    public <T extends PlanNode> Optional<T> findFirst() {
        return this.findFirstRecursive(this.node);
    }

    private <T extends PlanNode> Optional<T> findFirstRecursive(PlanNode node) {
        if (this.where.test(node)) {
            return Optional.of(node);
        }
        if (this.skipOnly.test(node)) {
            for (PlanNode source : node.getSources()) {
                Optional<T> found = this.findFirstRecursive(source);
                if (!found.isPresent()) continue;
                return found;
            }
        }
        return Optional.empty();
    }

    public <T extends PlanNode> List<T> findAll() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        this.findAllRecursive(this.node, nodes);
        return nodes.build();
    }

    private <T extends PlanNode> void findAllRecursive(PlanNode node, ImmutableList.Builder<T> nodes) {
        if (this.where.test(node)) {
            nodes.add((Object)node);
        }
        if (this.skipOnly.test(node)) {
            for (PlanNode source : node.getSources()) {
                this.findAllRecursive(source, nodes);
            }
        }
    }

    public PlanNode removeAll() {
        return this.removeAllRecursive(this.node);
    }

    private PlanNode removeAllRecursive(PlanNode node) {
        if (this.where.test(node)) {
            Preconditions.checkArgument((node.getSources().size() == 1 ? 1 : 0) != 0, (Object)"Unable to remove plan node as it contains 0 or more than 1 children");
            return node.getSources().get(0);
        }
        if (this.skipOnly.test(node)) {
            List sources = (List)node.getSources().stream().map(source -> this.removeAllRecursive((PlanNode)source)).collect(ImmutableCollectors.toImmutableList());
            return ChildReplacer.replaceChildren(node, sources);
        }
        return node;
    }

    public PlanNode removeFirst() {
        return this.removeFirstRecursive(this.node);
    }

    private PlanNode removeFirstRecursive(PlanNode node) {
        if (this.where.test(node)) {
            Preconditions.checkArgument((node.getSources().size() == 1 ? 1 : 0) != 0, (Object)"Unable to remove plan node as it contains 0 or more than 1 children");
            return node.getSources().get(0);
        }
        if (this.skipOnly.test(node)) {
            List<PlanNode> sources = node.getSources();
            if (sources.isEmpty()) {
                return node;
            }
            if (sources.size() == 1) {
                return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)this.removeFirstRecursive(sources.get(0))));
            }
            throw new IllegalArgumentException("Unable to remove first node when a node has multiple children, use removeAll instead");
        }
        return node;
    }

    public PlanNode replaceAll(PlanNode newPlanNode) {
        return this.replaceAllRecursive(this.node, newPlanNode);
    }

    private PlanNode replaceAllRecursive(PlanNode node, PlanNode nodeToReplace) {
        if (this.where.test(node)) {
            return nodeToReplace;
        }
        if (this.skipOnly.test(node)) {
            List sources = (List)node.getSources().stream().map(source -> this.replaceAllRecursive((PlanNode)source, nodeToReplace)).collect(ImmutableCollectors.toImmutableList());
            return ChildReplacer.replaceChildren(node, sources);
        }
        return node;
    }

    public PlanNode replaceFirst(PlanNode newPlanNode) {
        return this.replaceFirstRecursive(this.node, newPlanNode);
    }

    private PlanNode replaceFirstRecursive(PlanNode node, PlanNode nodeToReplace) {
        if (this.where.test(node)) {
            return nodeToReplace;
        }
        List<PlanNode> sources = node.getSources();
        if (sources.isEmpty()) {
            return node;
        }
        if (sources.size() == 1) {
            return ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)this.replaceFirstRecursive(node, sources.get(0))));
        }
        throw new IllegalArgumentException("Unable to replace first node when a node has multiple children, use replaceAll instead");
    }
}

