/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;

public class MergeWindows
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, Map<Symbol, Type> types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        return SimplePlanRewriter.rewriteWith(new Rewriter(), plan, ImmutableListMultimap.of());
    }

    private static class Rewriter
    extends SimplePlanRewriter<Multimap<WindowNode.Specification, WindowNode>> {
        private Rewriter() {
        }

        @Override
        protected PlanNode visitPlan(PlanNode node, SimplePlanRewriter.RewriteContext<Multimap<WindowNode.Specification, WindowNode>> context) {
            PlanNode newNode = context.defaultRewrite(node, (Multimap<WindowNode.Specification, WindowNode>)ImmutableListMultimap.of());
            for (WindowNode.Specification specification : context.get().keySet()) {
                Collection windows = context.get().get((Object)specification);
                newNode = Rewriter.collapseWindows(newNode, specification, windows);
            }
            return newNode;
        }

        @Override
        public PlanNode visitWindow(WindowNode node, SimplePlanRewriter.RewriteContext<Multimap<WindowNode.Specification, WindowNode>> context) {
            Preconditions.checkState((!node.getHashSymbol().isPresent() ? 1 : 0) != 0, (Object)"MergeWindows should be run before HashGenerationOptimizer");
            Preconditions.checkState((node.getPrePartitionedInputs().isEmpty() && node.getPreSortedOrderPrefix() == 0 ? 1 : 0) != 0, (Object)"MergeWindows should be run before AddExchanges");
            Preconditions.checkState((node.getWindowFunctions().values().stream().distinct().count() == 1L ? 1 : 0) != 0, (Object)"Frames expected to be identical");
            return context.rewrite(node.getSource(), (Multimap<WindowNode.Specification, WindowNode>)ImmutableListMultimap.builder().put((Object)node.getSpecification(), (Object)node).putAll(context.get()).build());
        }

        private static WindowNode collapseWindows(PlanNode source, WindowNode.Specification specification, Collection<WindowNode> windows) {
            WindowNode canonical = windows.iterator().next();
            return new WindowNode(canonical.getId(), source, specification, windows.stream().map(WindowNode::getWindowFunctions).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), canonical.getHashSymbol(), canonical.getPrePartitionedInputs(), canonical.getPreSortedOrderPrefix());
        }
    }
}

