/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.sql.planner.DependencyExtractor;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.tree.Expression;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

class Util {
    private Util() {
    }

    public static Optional<List<Symbol>> pruneInputs(Collection<Symbol> availableInputs, Collection<Expression> expressions) {
        HashSet<Symbol> available = new HashSet<Symbol>(availableInputs);
        Set<Symbol> required = DependencyExtractor.extractUnique(expressions);
        Sets.SetView used = Sets.intersection(required, available);
        if (used.size() == available.size()) {
            return Optional.empty();
        }
        return Optional.of(ImmutableList.copyOf((Collection)used));
    }

    public static PlanNode transpose(PlanNode parent, PlanNode child) {
        return child.replaceChildren((List<PlanNode>)ImmutableList.of((Object)parent.replaceChildren(child.getSources())));
    }
}

