/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.Util;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PruneTableScanColumns
implements Rule {
    @Override
    public Optional<PlanNode> apply(PlanNode node, Lookup lookup, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator) {
        if (!(node instanceof ProjectNode)) {
            return Optional.empty();
        }
        ProjectNode parent = (ProjectNode)node;
        PlanNode source = lookup.resolve(parent.getSource());
        if (!(source instanceof TableScanNode)) {
            return Optional.empty();
        }
        TableScanNode child = (TableScanNode)source;
        Optional<List<Symbol>> dependencies = Util.pruneInputs(child.getOutputSymbols(), parent.getAssignments().getExpressions());
        if (!dependencies.isPresent()) {
            return Optional.empty();
        }
        List<Symbol> newOutputs = dependencies.get();
        return Optional.of(new ProjectNode(parent.getId(), new TableScanNode(child.getId(), child.getTable(), newOutputs, newOutputs.stream().collect(Collectors.toMap(Function.identity(), e -> child.getAssignments().get(e))), child.getLayout(), child.getCurrentConstraint(), child.getOriginalConstraint()), parent.getAssignments()));
    }
}

