/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import java.util.Optional;

public class MergeLimitWithDistinct
implements Rule {
    @Override
    public Optional<PlanNode> apply(PlanNode node, Lookup lookup, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator) {
        if (!(node instanceof LimitNode)) {
            return Optional.empty();
        }
        LimitNode parent = (LimitNode)node;
        PlanNode input = lookup.resolve(parent.getSource());
        if (!(input instanceof AggregationNode)) {
            return Optional.empty();
        }
        AggregationNode child = (AggregationNode)input;
        if (this.isDistinct(child)) {
            return Optional.empty();
        }
        return Optional.of(new DistinctLimitNode(parent.getId(), child.getSource(), parent.getCount(), false, child.getHashSymbol()));
    }

    private boolean isDistinct(AggregationNode node) {
        return !node.getAggregations().isEmpty() || node.getOutputSymbols().size() != node.getGroupingKeys().size() || !node.getOutputSymbols().containsAll(node.getGroupingKeys());
    }
}

