/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;

public class ImplementFilteredAggregations
implements Rule {
    @Override
    public Optional<PlanNode> apply(PlanNode node, Lookup lookup, PlanNodeIdAllocator idAllocator, SymbolAllocator symbolAllocator) {
        if (!(node instanceof AggregationNode)) {
            return Optional.empty();
        }
        AggregationNode aggregation = (AggregationNode)node;
        boolean hasFilters = aggregation.getAggregations().entrySet().stream().anyMatch(e -> ((FunctionCall)e.getValue()).getFilter().isPresent() && !aggregation.getMasks().containsKey(e.getKey()));
        if (!hasFilters) {
            return Optional.empty();
        }
        Assignments.Builder newAssignments = Assignments.builder();
        ImmutableMap.Builder masks = ImmutableMap.builder().putAll(aggregation.getMasks());
        ImmutableMap.Builder calls = ImmutableMap.builder();
        for (Map.Entry<Symbol, FunctionCall> entry : aggregation.getAggregations().entrySet()) {
            Symbol output = entry.getKey();
            FunctionCall call = entry.getValue();
            calls.put((Object)output, (Object)new FunctionCall(call.getName(), call.getWindow(), Optional.empty(), call.isDistinct(), call.getArguments()));
            if (!call.getFilter().isPresent()) continue;
            Expression filter = (Expression)entry.getValue().getFilter().get();
            Symbol symbol = symbolAllocator.newSymbol(filter, (Type)BooleanType.BOOLEAN);
            newAssignments.put(symbol, filter);
            masks.put((Object)output, (Object)symbol);
        }
        newAssignments.putIdentities(aggregation.getSource().getOutputSymbols());
        return Optional.of(new AggregationNode(idAllocator.getNextId(), new ProjectNode(idAllocator.getNextId(), aggregation.getSource(), newAssignments.build()), (Map<Symbol, FunctionCall>)calls.build(), aggregation.getFunctions(), (Map<Symbol, Symbol>)masks.build(), aggregation.getGroupingSets(), aggregation.getStep(), aggregation.getHashSymbol(), aggregation.getGroupIdSymbol()));
    }
}

